/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.TestH5;
import ucar.nc2.iosp.hdf5.TestH5read;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;

public class TestH5npoess
extends TestCase {
    public void test1() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        TestH5read.readAllData(TestAll.testdataDir + "hdf5/npoess/ExampleFiles/AVAFO_NPP_d2003125_t10109_e101038_b9_c2005829155458_devl_Tst.h5");
    }

    public void test2() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("npoess/ExampleFiles/AVAFO_NPP_d2003125_t10109_e101038_b9_c2005829155458_devl_Tst.h5");
        Variable dset = ncfile.findVariable("Data_Products/VIIRS-AF-EDR/VIIRS-AF-EDR_Gran_0");
        Array data = dset.read();
        NCdump.printArray((Array)data, (String)"data", (PrintStream)System.out, null);
    }

    public void test3() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/reference"));
        NetcdfFile ncfile = TestH5.openH5("npoess/ExampleFiles/GDNBF-VNCCO_NPP_d2003125_t101038_e10116_b9_c2005829162517_dev.h5");
        Variable dset = ncfile.findVariable("Data_Products/VIIRS-DNB-FGEO/VIIRS-DNB-FGEO_Aggr");
        assert (null != dset);
    }

    public void problem() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        NetcdfFile ncfile = TestH5.open("C:/data/HDF5Files/CrIMSS - CrIS - ATMS/ATMS/ATMS_SCIENCE_RDR/RASCI_npp_d20030125_t104457_e104505_b00016_c20061210190242_den_SWC.h5");
        Variable dset = ncfile.findVariable("Data_Products/ATMS-SCIENCE-RDR/ATMS-SCIENCE-RDR_Aggr");
        assert (null != dset);
        Array data = dset.read();
        NCdump.printArray((Array)data, (String)dset.getName(), (PrintStream)System.out, null);
    }

    public void testNPoess() {
        TestH5read.readAllDir("D:/npoess");
    }
}

