/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.TestNC2;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.TestH5;
import ucar.nc2.iosp.hdf5.TestH5read;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;

public class TestOddTypes
extends TestCase {
    public void testOpaque() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        NetcdfFile ncfile = TestH5.openH5("samples/opaque.h5");
        System.out.println("\n" + ncfile);
        Variable v2 = ncfile.findVariable("Opaque");
        assert (v2 != null);
        Array data = v2.read();
        assert (data.getElementType() == ByteBuffer.class) : data.getElementType();
        System.out.println("data size= " + new Section(data.getShape()));
        NCdump.printArray((Array)data, (String)"Opaque data", (PrintStream)System.out, null);
        Array odata = v2.read(new Section("1:20"));
        assert (odata.getElementType() == ByteBuffer.class);
        assert (odata.getSize() == 20L);
        ncfile.close();
    }

    public void testEnum() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("support/enum.h5");
        Variable v2 = ncfile.findVariable("enum");
        assert (v2 != null);
        Array data = v2.read();
        assert (data.getElementType() == Integer.TYPE);
        NetcdfDataset ncd = TestH5.openH5dataset("support/enum.h5");
        v2 = ncd.findVariable("enum");
        assert (v2 != null);
        data = v2.read();
        assert (data.getElementType() == String.class);
        ncfile.close();
    }

    public void utestEnum2() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = NetcdfDataset.openFile((String)"D:/netcdf4/tst_enum_data.nc", null);
        Variable v2 = ncfile.findVariable("primary_cloud");
        assert (v2 != null);
        Array data = v2.read();
        assert (data.getElementType() == Byte.TYPE);
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)"D:/netcdf4/tst_enum_data.nc");
        v2 = ncd.findVariable("primary_cloud");
        assert (v2 != null);
        data = v2.read();
        assert (data.getElementType() == String.class);
        ncfile.close();
    }

    public void testTime() throws IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        String filename = TestAll.testdataDir + "hdf5/support/time.h5";
        NetcdfFile ncfile = TestNC2.open(filename);
        Variable v = ncfile.findVariable("dset");
        Array data = v.read();
        NCdump.printArray((Array)data, (String)"dset", (PrintStream)System.out, null);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        ncfile.close();
    }

    public void testBitfield() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        NetcdfFile ncfile = TestH5.openH5("samples/bitfield.h5");
        ncfile.close();
    }

    public void testVlenStrings() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        NetcdfFile ncfile = TestH5.openH5("support/vlstra.h5");
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        ncfile.close();
    }

    public void testAttString() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("support/attstr.h5");
        ncfile.close();
    }

    public void testCompoundString() throws InvalidRangeException, IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        TestH5read.readAllData(TestAll.testdataDir + "hdf5/support/cstr.h5");
    }

    public void testCompoundEnum() throws IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        String filename = TestAll.testdataDir + "hdf5/support/cenum.h5";
        NetcdfFile ncfile = TestNC2.open(filename);
        Variable v = ncfile.findVariable("enum");
        Array data = v.read();
        NCdump.printArray((Array)data, (String)"enum", (PrintStream)System.out, null);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        ncfile.close();
    }

    public void misc() throws IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        NetcdfFile ncfile = TestH5.openH5("support/bitop.h5");
        System.out.println("\n" + ncfile);
        ncfile.close();
    }

    public void testMisc() {
        byte[] heapId = new byte[]{0, 22, 32, 0, 0, 0, -19, 5};
        int offset = this.makeIntFromBytes(heapId, 1, 5);
        System.out.printf("%d%n", offset);
    }

    private int makeIntFromBytes(byte[] bb, int start, int n) {
        int result = 0;
        for (int i = start + n - 1; i >= start; --i) {
            result <<= 8;
            int b = bb[i];
            result += b < 0 ? b + 256 : b;
        }
        return result;
    }

    public void testAttStruct() throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "netcdf4/attributeStruct.nc"));
        Variable v = ncfile.findVariable("observations");
        assert (v != null);
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        Variable v2 = s.findVariable("tempMin");
        assert (v2 != null);
        assert (v2.getDataType() == DataType.FLOAT);
        assert (null != v2.findAttribute("units"));
        assert (null != v2.findAttribute("coordinates"));
        Attribute att = v2.findAttribute("units");
        assert (att.getStringValue().equals("degF"));
        ncfile.close();
    }

    public void testAttStruct2() throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "netcdf4/compound-attribute-test.nc"));
        Variable v = ncfile.findVariable("compound_test");
        assert (v != null);
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        Variable v2 = s.findVariable("field0");
        assert (v2 != null);
        assert (v2.getDataType() == DataType.FLOAT);
        Attribute att = v2.findAttribute("att_primitive_test");
        assert (!att.isString());
        assert ((double)att.getNumericValue().floatValue() == 1.0);
        att = v2.findAttribute("att_string_test");
        assert (att.getStringValue().equals("string for field 0"));
        att = v2.findAttribute("att_char_array_test");
        assert (att.getStringValue().equals("a"));
        ncfile.close();
    }

    public void testEmptyAtts() throws IOException {
        NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "netcdf4/testEmptyAtts.nc"));
        System.out.printf("%s%n", ncfile);
        ncfile.close();
    }
}

