/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class UspLightning1
extends AbstractIOServiceProvider {
    private static final String MAGIC = "USPLN-LIGHTNING";
    private ArrayInt.D1 dateArray;
    private ArrayDouble.D1 latArray;
    private ArrayDouble.D1 lonArray;
    private ArrayDouble.D1 ampArray;
    private ArrayInt.D1 nstrokesArray;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        int n = MAGIC.length();
        byte[] b = new byte[n];
        raf.read(b);
        String got = new String(b);
        return got.equals(MAGIC);
    }

    public String getFileTypeId() {
        return "USPLN/example1";
    }

    public String getFileTypeDescription() {
        return "USPLN/example1";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        int n;
        try {
            n = this.readAllData(raf);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException("bad data");
        }
        raf.close();
        Dimension recordDim = new Dimension("record", n);
        ncfile.addDimension(null, recordDim);
        Variable date = new Variable(ncfile, null, null, "date");
        date.setDimensions("record");
        date.setDataType(DataType.INT);
        String timeUnit = "seconds since 1970-01-01 00:00:00";
        date.addAttribute(new Attribute("long_name", "date of strike"));
        date.addAttribute(new Attribute("units", timeUnit));
        date.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        date.setCachedData((Array)this.dateArray, false);
        ncfile.addVariable(null, date);
        Variable lat = new Variable(ncfile, null, null, "lat");
        lat.setDimensions("record");
        lat.setDataType(DataType.DOUBLE);
        lat.addAttribute(new Attribute("long_name", "latitude"));
        lat.addAttribute(new Attribute("units", "degrees_north"));
        lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        lat.setCachedData((Array)this.latArray, false);
        ncfile.addVariable(null, lat);
        Variable lon = new Variable(ncfile, null, null, "lon");
        lon.setDimensions("record");
        lon.setDataType(DataType.DOUBLE);
        lon.addAttribute(new Attribute("long_name", "longitude"));
        lon.addAttribute(new Attribute("units", "degrees_east"));
        lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        lon.setCachedData((Array)this.lonArray, false);
        ncfile.addVariable(null, lon);
        Variable amp = new Variable(ncfile, null, null, "strikeAmplitude");
        amp.setDimensions("record");
        amp.setDataType(DataType.DOUBLE);
        amp.addAttribute(new Attribute("long_name", "amplitude of strike"));
        amp.addAttribute(new Attribute("units", "kAmps"));
        amp.addAttribute(new Attribute("missing_value", (Number)new Double(999.0)));
        amp.setCachedData((Array)this.ampArray, false);
        ncfile.addVariable(null, amp);
        Variable nstrokes = new Variable(ncfile, null, null, "strokeCount");
        nstrokes.setDimensions("record");
        nstrokes.setDataType(DataType.INT);
        nstrokes.addAttribute(new Attribute("long_name", "number of strokes per flash"));
        nstrokes.addAttribute(new Attribute("units", ""));
        nstrokes.setCachedData((Array)this.nstrokesArray, false);
        ncfile.addVariable(null, nstrokes);
        ncfile.addAttribute(null, new Attribute("title", "USPN Lightning Data"));
        ncfile.addAttribute(null, new Attribute("history", "Read directly by Netcdf Java IOSP"));
        ncfile.addAttribute(null, new Attribute("Conventions", "Unidata Observation Dataset v1.0"));
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.POINT.toString()));
        ncfile.addAttribute(null, new Attribute("observationDimension", "record"));
        MAMath.MinMax mm = MAMath.getMinMax((Array)this.dateArray);
        ncfile.addAttribute(null, new Attribute("time_coverage_start", (int)mm.min + " " + timeUnit));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", (int)mm.max + " " + timeUnit));
        mm = MAMath.getMinMax((Array)this.latArray);
        ncfile.addAttribute(null, new Attribute("geospatial_lat_min", (Number)new Double(mm.min)));
        ncfile.addAttribute(null, new Attribute("geospatial_lat_max", (Number)new Double(mm.max)));
        mm = MAMath.getMinMax((Array)this.lonArray);
        ncfile.addAttribute(null, new Attribute("geospatial_lon_min", (Number)new Double(mm.min)));
        ncfile.addAttribute(null, new Attribute("geospatial_lon_max", (Number)new Double(mm.max)));
        ncfile.finish();
    }

    int readAllData(RandomAccessFile raf) throws IOException, NumberFormatException, ParseException {
        String line;
        ArrayList<Strike> records = new ArrayList<Strike>();
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        raf.seek(0L);
        int count = 0;
        while ((line = raf.readLine()) != null) {
            if (line.startsWith(MAGIC)) continue;
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            while (stoker.hasMoreTokens()) {
                Date d = isoDateTimeFormat.parse(stoker.nextToken());
                double lat = Double.parseDouble(stoker.nextToken());
                double lon = Double.parseDouble(stoker.nextToken());
                double amp = Double.parseDouble(stoker.nextToken());
                String tok = stoker.nextToken();
                int nstrikes = Integer.parseInt(tok);
                Strike s = new Strike(d, lat, lon, amp, nstrikes);
                records.add(s);
                if (count >= 10) continue;
                System.out.println(count + " " + isoDateTimeFormat.format(d) + " " + s);
            }
            ++count;
        }
        System.out.println("processed " + count + " records");
        int n = records.size();
        int[] shape = new int[]{n};
        this.dateArray = (ArrayInt.D1)Array.factory((DataType)DataType.INT, (int[])shape);
        this.latArray = (ArrayDouble.D1)Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        this.lonArray = (ArrayDouble.D1)Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        this.ampArray = (ArrayDouble.D1)Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        this.nstrokesArray = (ArrayInt.D1)Array.factory((DataType)DataType.INT, (int[])shape);
        for (int i = 0; i < records.size(); ++i) {
            Strike strike = (Strike)records.get(i);
            this.dateArray.set(i, strike.d);
            this.latArray.set(i, strike.lat);
            this.lonArray.set(i, strike.lon);
            this.ampArray.set(i, strike.amp);
            this.nstrokesArray.set(i, strike.n);
        }
        return n;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return null;
    }

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException {
        NetcdfFile.registerIOProvider(UspLightning1.class);
        NetcdfFile ncfile = NetcdfFile.open((String)(TestAll.testdataDir + "lightning/uspln/uspln_20061023.18"));
        System.out.println("ncfile = \n" + ncfile);
    }

    private class Strike {
        int d;
        double lat;
        double lon;
        double amp;
        int n;

        Strike(Date d, double lat, double lon, double amp, int n) {
            this.d = (int)(d.getTime() / 1000L);
            this.lat = lat;
            this.lon = lon;
            this.amp = amp;
            this.n = n;
        }

        public String toString() {
            return this.lat + " " + this.lon + " " + this.amp + " " + this.n;
        }
    }
}

