/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nids;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestNids
extends TestCase {
    public static String basereflectFile = TestAll.cdmLocalTestDataDir + "nids/N0R_20041119_2147";
    public static String basereflect1File = TestAll.cdmLocalTestDataDir + "nids/N1R_20050119_1548";
    public static String basereflect2File = TestAll.cdmLocalTestDataDir + "nids/N2R_20050119_1528";
    public static String basereflect3File = TestAll.cdmLocalTestDataDir + "nids/N3R_20050119_1548";
    public static String basereflectCFile = TestAll.cdmLocalTestDataDir + "nids/NCR_20050119_1548";
    public static String basereflect248File = TestAll.cdmLocalTestDataDir + "nids/N0Z_20050119_1538";
    public static String radialVelocityFile = TestAll.cdmLocalTestDataDir + "nids/N0V_20041117_1646";
    public static String radialVelocity1File = TestAll.cdmLocalTestDataDir + "nids/N1V_20050119_1548";
    public static String echotopFile = TestAll.cdmLocalTestDataDir + "nids/NET_20041123_1648";
    public static String oneHourPrecipFile = TestAll.cdmLocalTestDataDir + "nids/N1P_20041122_1837";
    public static String StormRelMeanVel0File = TestAll.cdmLocalTestDataDir + "nids/N0S_20050119_1548";
    public static String StormRelMeanVel1File = TestAll.cdmLocalTestDataDir + "nids/N1S_20041117_1640";
    public static String StormRelMeanVel2File = TestAll.cdmLocalTestDataDir + "nids/N2S_20050120_1806";
    public static String StormRelMeanVel3File = TestAll.cdmLocalTestDataDir + "nids/N3S_20050120_1806";
    public static String totalPrecipFile = TestAll.cdmLocalTestDataDir + "nids/NTP_20050119_1528";
    public static String digitPrecipArrayFile = TestAll.cdmLocalTestDataDir + "nids/DPA_20041123_1709";
    public static String vertIntegLiquidFile = TestAll.cdmLocalTestDataDir + "nids/NVL_20041130_1946";
    public static String vadWindProfileFile = TestAll.cdmLocalTestDataDir + "nids/NVW_20041117_1657";
    public static boolean dumpFile = false;

    public void testNidsReadRadial() throws IOException {
        Variable v;
        NetcdfFile ncfile;
        block54: {
            block53: {
                block52: {
                    block51: {
                        block50: {
                            block49: {
                                block48: {
                                    block47: {
                                        block46: {
                                            block45: {
                                                block44: {
                                                    ncfile = null;
                                                    try {
                                                        System.out.println("**** Open " + basereflectFile);
                                                        ncfile = NetcdfFile.open((String)basereflectFile);
                                                    }
                                                    catch (IOException e) {
                                                        System.out.println(" fail = " + e);
                                                        e.printStackTrace();
                                                        if ($assertionsDisabled) break block44;
                                                        throw new AssertionError();
                                                    }
                                                }
                                                v = null;
                                                v = ncfile.findVariable("BaseReflectivity");
                                                this.testReadData(v);
                                                assert (null != v.getDimension(0));
                                                assert (null != v.getDimension(1));
                                                ncfile.close();
                                                try {
                                                    System.out.println("**** Open " + basereflect1File);
                                                    ncfile = NetcdfFile.open((String)basereflect1File);
                                                }
                                                catch (IOException e) {
                                                    System.out.println(" fail = " + e);
                                                    e.printStackTrace();
                                                    if ($assertionsDisabled) break block45;
                                                    throw new AssertionError();
                                                }
                                            }
                                            v = ncfile.findVariable("BaseReflectivity");
                                            this.testReadData(v);
                                            assert (null != v.getDimension(0));
                                            assert (null != v.getDimension(1));
                                            ncfile.close();
                                            try {
                                                System.out.println("**** Open " + basereflect2File);
                                                ncfile = NetcdfFile.open((String)basereflect2File);
                                            }
                                            catch (IOException e) {
                                                System.out.println(" fail = " + e);
                                                e.printStackTrace();
                                                if ($assertionsDisabled) break block46;
                                                throw new AssertionError();
                                            }
                                        }
                                        v = ncfile.findVariable("BaseReflectivity");
                                        this.testReadData(v);
                                        assert (null != v.getDimension(0));
                                        assert (null != v.getDimension(1));
                                        ncfile.close();
                                        try {
                                            System.out.println("**** Open " + basereflect3File);
                                            ncfile = NetcdfFile.open((String)basereflect3File);
                                        }
                                        catch (IOException e) {
                                            System.out.println(" fail = " + e);
                                            e.printStackTrace();
                                            if ($assertionsDisabled) break block47;
                                            throw new AssertionError();
                                        }
                                    }
                                    v = ncfile.findVariable("BaseReflectivity");
                                    this.testReadData(v);
                                    assert (null != v.getDimension(0));
                                    assert (null != v.getDimension(1));
                                    ncfile.close();
                                    try {
                                        System.out.println("**** Open " + basereflect248File);
                                        ncfile = NetcdfFile.open((String)basereflect248File);
                                    }
                                    catch (IOException e) {
                                        System.out.println(" fail = " + e);
                                        e.printStackTrace();
                                        if ($assertionsDisabled) break block48;
                                        throw new AssertionError();
                                    }
                                }
                                v = ncfile.findVariable("BaseReflectivity248");
                                this.testReadData(v);
                                assert (null != v.getDimension(0));
                                assert (null != v.getDimension(1));
                                ncfile.close();
                                try {
                                    System.out.println("**** Open " + StormRelMeanVel0File);
                                    ncfile = NetcdfFile.open((String)StormRelMeanVel0File);
                                }
                                catch (IOException e) {
                                    System.out.println(" fail = " + e);
                                    e.printStackTrace();
                                    if ($assertionsDisabled) break block49;
                                    throw new AssertionError();
                                }
                            }
                            v = ncfile.findVariable("StormMeanVelocity");
                            this.testReadData(v);
                            assert (null != v.getDimension(0));
                            assert (null != v.getDimension(1));
                            ncfile.close();
                            try {
                                System.out.println("**** Open " + StormRelMeanVel1File);
                                ncfile = NetcdfFile.open((String)StormRelMeanVel1File);
                            }
                            catch (IOException e) {
                                System.out.println(" fail = " + e);
                                e.printStackTrace();
                                if ($assertionsDisabled) break block50;
                                throw new AssertionError();
                            }
                        }
                        v = ncfile.findVariable("StormMeanVelocity");
                        this.testReadData(v);
                        assert (null != v.getDimension(0));
                        assert (null != v.getDimension(1));
                        ncfile.close();
                        try {
                            System.out.println("**** Open " + StormRelMeanVel2File);
                            ncfile = NetcdfFile.open((String)StormRelMeanVel2File);
                        }
                        catch (IOException e) {
                            System.out.println(" fail = " + e);
                            e.printStackTrace();
                            if ($assertionsDisabled) break block51;
                            throw new AssertionError();
                        }
                    }
                    v = ncfile.findVariable("StormMeanVelocity");
                    this.testReadData(v);
                    assert (null != v.getDimension(0));
                    assert (null != v.getDimension(1));
                    ncfile.close();
                    try {
                        System.out.println("**** Open " + StormRelMeanVel3File);
                        ncfile = NetcdfFile.open((String)StormRelMeanVel3File);
                    }
                    catch (IOException e) {
                        System.out.println(" fail = " + e);
                        e.printStackTrace();
                        if ($assertionsDisabled) break block52;
                        throw new AssertionError();
                    }
                }
                v = ncfile.findVariable("StormMeanVelocity");
                this.testReadData(v);
                assert (null != v.getDimension(0));
                assert (null != v.getDimension(1));
                ncfile.close();
                try {
                    System.out.println("**** Open " + radialVelocityFile);
                    ncfile = NetcdfFile.open((String)radialVelocityFile);
                }
                catch (IOException e) {
                    System.out.println(" fail = " + e);
                    e.printStackTrace();
                    if ($assertionsDisabled) break block53;
                    throw new AssertionError();
                }
            }
            v = ncfile.findVariable("RadialVelocity");
            this.testReadData(v);
            assert (null != v.getDimension(0));
            assert (null != v.getDimension(1));
            ncfile.close();
            try {
                System.out.println("**** Open " + radialVelocity1File);
                ncfile = NetcdfFile.open((String)radialVelocity1File);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block54;
                throw new AssertionError();
            }
        }
        v = ncfile.findVariable("RadialVelocity");
        this.testReadData(v);
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        ncfile.close();
    }

    public void testNidsReadRadialN1P() throws IOException {
        Variable v;
        NetcdfFile ncfile;
        block9: {
            block8: {
                ncfile = null;
                try {
                    System.out.println("**** Open " + oneHourPrecipFile);
                    ncfile = NetcdfFile.open((String)oneHourPrecipFile);
                }
                catch (IOException e) {
                    System.out.println(" fail = " + e);
                    e.printStackTrace();
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
            v = ncfile.findVariable("Precip1hr_RAW");
            this.testReadData(v);
            assert (null != v.getDimension(0));
            assert (null != v.getDimension(1));
            ncfile.close();
            try {
                System.out.println("**** Open " + totalPrecipFile);
                ncfile = NetcdfFile.open((String)totalPrecipFile);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        v = ncfile.findVariable("PrecipAccum_RAW");
        this.testReadData(v);
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        ncfile.close();
    }

    public void testNidsReadRaster() throws IOException {
        Variable v;
        NetcdfFile ncfile;
        block16: {
            block15: {
                block14: {
                    ncfile = null;
                    try {
                        System.out.println("**** Open " + echotopFile);
                        ncfile = NetcdfFile.open((String)echotopFile);
                    }
                    catch (IOException e) {
                        System.out.println(" fail = " + e);
                        e.printStackTrace();
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
                v = ncfile.findVariable("EchoTop");
                this.testReadData(v);
                assert (null != v.getDimension(0));
                assert (null != v.getDimension(1));
                ncfile.close();
                try {
                    System.out.println("**** Open " + vertIntegLiquidFile);
                    ncfile = NetcdfFile.open((String)vertIntegLiquidFile);
                }
                catch (IOException e) {
                    System.out.println(" fail = " + e);
                    e.printStackTrace();
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError();
                }
            }
            v = ncfile.findVariable("VertLiquid");
            this.testReadData(v);
            assert (null != v.getDimension(0));
            assert (null != v.getDimension(1));
            v = ncfile.findVariable("VertLiquid_RAW");
            this.testReadData(v);
            assert (null != v.getDimension(0));
            assert (null != v.getDimension(1));
            ncfile.close();
            try {
                System.out.println("**** Open " + basereflectCFile);
                ncfile = NetcdfFile.open((String)basereflectCFile);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError();
            }
        }
        v = ncfile.findVariable("BaseReflectivityComp");
        this.testReadData(v);
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        ncfile.close();
    }

    public void testNidsReadNVW() throws IOException {
        Variable v;
        NetcdfFile ncfile;
        block4: {
            ncfile = null;
            v = null;
            Object a = null;
            try {
                System.out.println("**** Open " + vadWindProfileFile);
                ncfile = NetcdfFile.open((String)vadWindProfileFile);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (null != ncfile.findVariable("textStruct_code8"));
        assert (null != ncfile.findVariable("textStruct_code8").getDimension(0));
        v = ncfile.findVariable("unlinkedVectorStruct");
        this.testReadDataAsShort((Structure)v, "iValue");
        v = ncfile.findVariable("VADWindSpeed");
        this.testReadData(v);
        v = ncfile.findVariable("TabMessagePage");
        this.testReadData(v);
        ncfile.close();
    }

    public void testNidsReadDPA() throws IOException {
        Variable v;
        NetcdfFile ncfile;
        block3: {
            ncfile = null;
            v = null;
            Object a = null;
            try {
                System.out.println("**** Open " + digitPrecipArrayFile);
                ncfile = NetcdfFile.open((String)digitPrecipArrayFile);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        v = ncfile.findVariable("PrecipArray_0");
        this.testReadData(v);
        assert (null != ncfile.findVariable("textStruct_code1").getDimension(0));
        ncfile.close();
    }

    private void testReadData(Variable v) {
        Array a;
        block6: {
            a = null;
            assert (null != v);
            assert (null != v.getDimension(0));
            try {
                a = v.read();
                assert (null != a);
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (v.getSize() == a.getSize());
    }

    private void testReadDataAsShort(Structure v, String memberName) {
        Array a;
        block8: {
            a = null;
            assert (null != v);
            assert (null != v.getDimension(0));
            try {
                a = v.read();
                assert (null != a);
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        assert (v.getSize() == a.getSize());
        assert (a instanceof ArrayStructure);
        int sum = 0;
        ArrayStructure as = (ArrayStructure)a;
        int n = (int)as.getSize();
        for (int i = 0; i < n; ++i) {
            StructureData sdata = as.getStructureData(i);
            sum += sdata.getScalarShort(memberName);
        }
        System.out.println("test short sum = " + sum);
    }
}

