/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestAggExisting
extends TestCase {
    public TestAggExisting(String name) {
        super(name);
    }

    public void testNcmlDirect() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "aggExisting.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        System.out.println(" TestNcmlAggExisting.open " + filename);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testReadData((NetcdfFile)ncfile);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testNcmlDataset() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "aggExisting.xml";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        System.out.println(" TestNcmlAggExisting.open " + filename);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testReadData((NetcdfFile)ncfile);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testNcmlDatasetWcoords() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "aggExistingWcoords.xml";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        System.out.println(" testNcmlDatasetWcoords.open " + filename);
        this.testDimensions((NetcdfFile)ncfile);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile);
        this.testReadData((NetcdfFile)ncfile);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
        System.out.println(" testNcmlDatasetWcoords.closed ");
    }

    public void testNcmlDatasetNoCoords() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "aggExistingNoCoords.xml";
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        }
        catch (Exception e) {
            return;
        }
        assert (false);
    }

    public void testNcmlDatasetNoCoordsDir() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "aggExistingNoCoordsDir.xml";
        try {
            NetcdfDataset.openDataset((String)filename, (boolean)true, null);
        }
        catch (Exception e) {
            return;
        }
        assert (false);
    }

    public void testDimensions(NetcdfFile ncfile) {
        Dimension latDim = ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 3);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("lon");
        assert (null != lonDim);
        assert (lonDim.getName().equals("lon"));
        assert (lonDim.getLength() == 4);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 59);
    }

    public void testCoordVar(NetcdfFile ncfile) throws IOException {
        Variable lat = ncfile.findVariable("lat");
        assert (null != lat);
        assert (lat.getName().equals("lat"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 3L);
        assert (lat.getShape()[0] == 3);
        assert (lat.getDataType() == DataType.FLOAT);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("lat")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degrees_north"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 3L);
        assert (data.getShape()[0] == 3);
        assert (data.getElementType() == Float.TYPE);
        IndexIterator dataI = data.getIndexIterator();
        assert (TestUtils.close(dataI.getDoubleNext(), 41.0));
        assert (TestUtils.close(dataI.getDoubleNext(), 40.0));
        assert (TestUtils.close(dataI.getDoubleNext(), 39.0));
    }

    public void testAggCoordVar(NetcdfFile ncfile) {
        block17: {
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            String testAtt = ncfile.findAttValueIgnoreCase(time, "ncmlAdded", null);
            assert (testAtt != null);
            assert (testAtt.equals("timeAtt"));
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 59L);
            assert (time.getShape()[0] == 59);
            assert (time.getDataType() == DataType.INT);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 59L);
                assert (data.getShape()[0] == 59);
                assert (data.getElementType() == Integer.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    assert (dataI.getIntNext() == count++) : dataI.getIntCurrent();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
    }

    public void testReadData(NetcdfFile ncfile) {
        block24: {
            Variable v = ncfile.findVariable("T");
            assert (null != v);
            assert (v.getName().equals("T"));
            assert (v.getRank() == 3);
            assert (v.getSize() == 708L) : v.getSize();
            assert (v.getShape()[0] == 59);
            assert (v.getShape()[1] == 3);
            assert (v.getShape()[2] == 4);
            assert (v.getDataType() == DataType.DOUBLE);
            assert (!v.isCoordinateVariable());
            assert (v.getDimension(0) == ncfile.findDimension("time"));
            assert (v.getDimension(1) == ncfile.findDimension("lat"));
            assert (v.getDimension(2) == ncfile.findDimension("lon"));
            try {
                Array data = v.read();
                assert (data.getRank() == 3);
                assert (data.getSize() == 708L);
                assert (data.getShape()[0] == 59);
                assert (data.getShape()[1] == 3);
                assert (data.getShape()[2] == 4);
                assert (data.getElementType() == Double.TYPE);
                int[] shape = data.getShape();
                Index tIndex = data.getIndex();
                for (int i = 0; i < shape[0]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        for (int k = 0; k < shape[2]; ++k) {
                            double val = data.getDouble(tIndex.set(i, j, k));
                            assert (TestUtils.close(val, (double)(100 * i + 10 * j + k))) : val;
                        }
                    }
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block24;
                throw new AssertionError();
            }
        }
    }

    public void testReadSlice(NetcdfFile ncfile, int[] origin, int[] shape) throws IOException, InvalidRangeException {
        Variable v = ncfile.findVariable("T");
        Array data = v.read(origin, shape);
        assert (data.getRank() == 3);
        assert (data.getSize() == (long)(shape[0] * shape[1] * shape[2]));
        assert (data.getShape()[0] == shape[0]) : data.getShape()[0] + " " + shape[0];
        assert (data.getShape()[1] == shape[1]);
        assert (data.getShape()[2] == shape[2]);
        assert (data.getElementType() == Double.TYPE);
        Index tIndex = data.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    double val = data.getDouble(tIndex.set(i, j, k));
                    assert (TestUtils.close(val, (double)(100 * (i + origin[0]) + 10 * j + k))) : val;
                }
            }
        }
    }

    public void testReadSlice(NetcdfFile ncfile) throws IOException, InvalidRangeException {
        this.testReadSlice(ncfile, new int[]{0, 0, 0}, new int[]{59, 3, 4});
        this.testReadSlice(ncfile, new int[]{0, 0, 0}, new int[]{2, 3, 2});
        this.testReadSlice(ncfile, new int[]{25, 0, 0}, new int[]{10, 3, 4});
        this.testReadSlice(ncfile, new int[]{44, 0, 0}, new int[]{10, 2, 3});
    }
}

