/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestAggMisc
extends TestCase {
    public TestAggMisc(String name) {
        super(name);
    }

    public void testNestedValues() throws IOException, InvalidRangeException, InterruptedException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' >\n  <aggregation dimName='time' type='joinExisting'>\n   <netcdf>\n     <dimension name='time' isUnlimited='true' length='10'/>\n     <variable name='time' shape='time' type='double'>\n         <values start='0' increment='1' />\n     </variable>\n   </netcdf>\n   <netcdf >\n     <dimension name='time' isUnlimited='true' length='10'/>\n     <variable name='time' shape='time' type='double'>\n         <values start='10' increment='1' />\n     </variable>\n   </netcdf>\n  </aggregation>\n</netcdf>";
        String location = "testNestedValues.ncml";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)location, null);
        TestAll.readAll((NetcdfFile)ncfile);
        Variable v = ncfile.findVariable("time");
        Array data = v.read();
        assert (data.getSize() == 20L);
        NCdumpW.printArray((Array)data);
        ncfile.close();
    }

    public void testNestedAgg() throws IOException, InvalidRangeException, InterruptedException {
        String filename = "file:./" + TestAll.cdmLocalTestDataDir + "testNested.ncml";
        NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
        TestAll.readAll(ncfile);
        Variable v = ncfile.findVariable("time");
        Array data = v.read();
        assert (data.getSize() == 59L);
        NCdumpW.printArray((Array)data);
        ncfile.close();
    }
}

