/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestNcMLModifyAtts
extends TestCase {
    NetcdfFile ncfile = null;

    public TestNcMLModifyAtts(String name) {
        super(name);
    }

    public void setUp() {
        String filename = "file:" + TestNcML.topDir + "modifyAtts.xml";
        try {
            this.ncfile = NcMLReader.readNcML((String)filename, null);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    protected void tearDown() throws IOException {
        this.ncfile.close();
    }

    public void testGlobalAtt() {
        Attribute att = this.ncfile.findGlobalAttribute("Conventions");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("Metapps"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
    }

    public void testVarAtt() {
        Variable v = this.ncfile.findVariable("rh");
        assert (null != v);
        Attribute att = v.findAttribute("long_name");
        assert (null == att);
        att = v.findAttribute("units");
        assert (null == att);
        att = v.findAttribute("UNITS");
        assert (null != att);
        assert (att.getStringValue().equals("percent"));
        att = v.findAttribute("longer_name");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("Abe said what?"));
    }

    public void testStructure() {
        Attribute att = this.ncfile.findGlobalAttribute("title");
        assert (null == att);
        Dimension latDim = this.ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 3);
        assert (!latDim.isUnlimited());
        Dimension timeDim = this.ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 2);
        assert (timeDim.isUnlimited());
    }

    public void testReadCoordvar() {
        Variable lat = this.ncfile.findVariable("lat");
        assert (null != lat);
        assert (lat.getName().equals("lat"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 3L);
        assert (lat.getShape()[0] == 3);
        assert (lat.getDataType() == DataType.FLOAT);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0) == this.ncfile.findDimension("lat"));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degrees_north"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = lat.read();
            assert (data.getRank() == 1);
            assert (data.getSize() == 3L);
            assert (data.getShape()[0] == 3);
            assert (data.getElementType() == Float.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 41.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 40.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 39.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadData() {
        Variable v = this.ncfile.findVariable("rh");
        assert (null != v);
        assert (v.getName().equals("rh"));
        assert (v.getRank() == 3);
        assert (v.getSize() == 24L);
        assert (v.getShape()[0] == 2);
        assert (v.getShape()[1] == 3);
        assert (v.getShape()[2] == 4);
        assert (v.getDataType() == DataType.INT);
        assert (!v.isCoordinateVariable());
        assert (v.isUnlimited());
        assert (v.getDimension(0) == this.ncfile.findDimension("time"));
        assert (v.getDimension(1) == this.ncfile.findDimension("lat"));
        assert (v.getDimension(2) == this.ncfile.findDimension("lon"));
        try {
            Array data = v.read();
            assert (data.getRank() == 3);
            assert (data.getSize() == 24L);
            assert (data.getShape()[0] == 2);
            assert (data.getShape()[1] == 3);
            assert (data.getShape()[2] == 4);
            assert (data.getElementType() == Integer.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (dataI.getIntNext() == 1);
            assert (dataI.getIntNext() == 2);
            assert (dataI.getIntNext() == 3);
            assert (dataI.getIntNext() == 4);
            assert (dataI.getIntNext() == 5);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadSlice() {
        block16: {
            Variable v = this.ncfile.findVariable("rh");
            int[] origin = new int[3];
            int[] shape = new int[]{2, 3, 1};
            try {
                Array data = v.read(origin, shape);
                assert (data.getRank() == 3);
                assert (data.getSize() == 6L);
                assert (data.getShape()[0] == 2);
                assert (data.getShape()[1] == 3);
                assert (data.getShape()[2] == 1);
                assert (data.getElementType() == Integer.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                assert (dataI.getIntNext() == 1);
                assert (dataI.getIntNext() == 5);
                assert (dataI.getIntNext() == 9);
                assert (dataI.getIntNext() == 21);
                assert (dataI.getIntNext() == 25);
                assert (dataI.getIntNext() == 29);
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                if ($assertionsDisabled) break block16;
                throw new AssertionError();
            }
        }
    }

    public void testReadSlice2() {
        block15: {
            Variable v = this.ncfile.findVariable("rh");
            int[] origin = new int[3];
            int[] shape = new int[]{2, 1, 3};
            try {
                Array data = v.read(origin, shape).reduce();
                assert (data.getRank() == 2);
                assert (data.getSize() == 6L);
                assert (data.getShape()[0] == 2);
                assert (data.getShape()[1] == 3);
                assert (data.getElementType() == Integer.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                assert (dataI.getIntNext() == 1);
                assert (dataI.getIntNext() == 2);
                assert (dataI.getIntNext() == 3);
                assert (dataI.getIntNext() == 21);
                assert (dataI.getIntNext() == 22);
                assert (dataI.getIntNext() == 23);
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
    }

    public void testReadData2() {
        Variable v = this.ncfile.findVariable("Temperature");
        assert (null == v);
        v = this.ncfile.findVariable("T");
        assert (null != v);
        assert (v.getName().equals("T"));
        assert (v.getRank() == 3);
        assert (v.getSize() == 24L);
        assert (v.getShape()[0] == 2);
        assert (v.getShape()[1] == 3);
        assert (v.getShape()[2] == 4);
        assert (v.getDataType() == DataType.DOUBLE);
        assert (!v.isCoordinateVariable());
        assert (v.isUnlimited());
        assert (v.getDimension(0) == this.ncfile.findDimension("time"));
        assert (v.getDimension(1) == this.ncfile.findDimension("lat"));
        assert (v.getDimension(2) == this.ncfile.findDimension("lon"));
        Attribute att = v.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degC"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = v.read();
            assert (data.getRank() == 3);
            assert (data.getSize() == 24L);
            assert (data.getShape()[0] == 2);
            assert (data.getShape()[1] == 3);
            assert (data.getShape()[2] == 4);
            assert (data.getElementType() == Double.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 1.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 2.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 3.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 4.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 2.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            String filename = "file:///E:/dev/NCdataset/xml/override.xml";
            NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
            System.out.println("\nncfile = " + ncfile);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }
}

