/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestNcMLRenameVar
extends TestCase {
    NetcdfFile ncfile = null;
    String filename = "file:./" + TestNcML.topDir + "renameVar.xml";

    public TestNcMLRenameVar(String name) {
        super(name);
    }

    public void setUp() {
        try {
            this.ncfile = NcMLReader.readNcML((String)this.filename, null);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    protected void tearDown() throws IOException {
        this.ncfile.close();
    }

    public void testStructure() {
        Attribute att = this.ncfile.findGlobalAttribute("title");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("Example Data"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        att = this.ncfile.findGlobalAttribute("testFloat");
        assert (null != att);
        assert (att.isArray());
        assert (!att.isString());
        assert (att.getDataType() == DataType.FLOAT);
        assert (att.getStringValue() == null);
        assert (att.getNumericValue().equals(Float.valueOf(1.0f)));
        assert (att.getNumericValue(3).equals(Float.valueOf(4.0f)));
        Dimension latDim = this.ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 3);
        assert (!latDim.isUnlimited());
        Dimension timeDim = this.ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 4);
        assert (timeDim.isUnlimited());
    }

    public void testReadCoordvar() {
        Variable lat = this.ncfile.findVariable("lat");
        assert (null != lat);
        assert (lat.getName().equals("lat"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 3L);
        assert (lat.getShape()[0] == 3);
        assert (lat.getDataType() == DataType.FLOAT);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0) == this.ncfile.findDimension("lat"));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degrees_north"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = lat.read();
            assert (data.getRank() == 1);
            assert (data.getSize() == 3L);
            assert (data.getShape()[0] == 3);
            assert (data.getElementType() == Float.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (this.close(dataI.getDoubleNext(), 41.0));
            assert (this.close(dataI.getDoubleNext(), 40.0));
            assert (this.close(dataI.getDoubleNext(), 39.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadData() {
        Variable v = this.ncfile.findVariable("ReletiveHumidity");
        assert (null != v);
        assert (v.getName().equals("ReletiveHumidity"));
        assert (v.getRank() == 3);
        assert (v.getSize() == 48L);
        assert (v.getShape()[0] == 4);
        assert (v.getShape()[1] == 3);
        assert (v.getShape()[2] == 4);
        assert (v.getDataType() == DataType.INT);
        assert (!v.isCoordinateVariable());
        assert (v.isUnlimited());
        assert (v.getDimension(0) == this.ncfile.findDimension("time"));
        assert (v.getDimension(1) == this.ncfile.findDimension("lat"));
        assert (v.getDimension(2) == this.ncfile.findDimension("lon"));
        Attribute att = v.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("percent"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = v.read();
            assert (data.getRank() == 3);
            assert (data.getSize() == 48L);
            assert (data.getShape()[0] == 4);
            assert (data.getShape()[1] == 3);
            assert (data.getShape()[2] == 4);
            assert (data.getElementType() == Integer.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (dataI.getIntNext() == 1);
            assert (dataI.getIntNext() == 2);
            assert (dataI.getIntNext() == 3);
            assert (dataI.getIntNext() == 4);
            assert (dataI.getIntNext() == 5);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadSlice() {
        block16: {
            Variable v = this.ncfile.findVariable("ReletiveHumidity");
            int[] origin = new int[3];
            int[] shape = new int[]{2, 3, 1};
            try {
                Array data = v.read(origin, shape);
                assert (data.getRank() == 3);
                assert (data.getSize() == 6L);
                assert (data.getShape()[0] == 2);
                assert (data.getShape()[1] == 3);
                assert (data.getShape()[2] == 1);
                assert (data.getElementType() == Integer.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                assert (dataI.getIntNext() == 1);
                assert (dataI.getIntNext() == 5);
                assert (dataI.getIntNext() == 9);
                assert (dataI.getIntNext() == 21);
                assert (dataI.getIntNext() == 25);
                assert (dataI.getIntNext() == 29);
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError();
            }
        }
    }

    public void testReadSlice2() {
        block15: {
            Variable v = this.ncfile.findVariable("ReletiveHumidity");
            int[] origin = new int[3];
            int[] shape = new int[]{2, 1, 3};
            try {
                Array data = v.read(origin, shape).reduce();
                assert (data.getRank() == 2);
                assert (data.getSize() == 6L);
                assert (data.getShape()[0] == 2);
                assert (data.getShape()[1] == 3);
                assert (data.getElementType() == Integer.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                assert (dataI.getIntNext() == 1);
                assert (dataI.getIntNext() == 2);
                assert (dataI.getIntNext() == 3);
                assert (dataI.getIntNext() == 21);
                assert (dataI.getIntNext() == 22);
                assert (dataI.getIntNext() == 23);
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
    }

    boolean close(double d1, double d2) {
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }
}

