/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.util.CompareNetcdf;

public class TestNcMLequals
extends TestCase {
    public TestNcMLequals(String name) {
        super(name);
    }

    public void testEquals() throws IOException {
        this.testEquals("file:" + TestNcML.topDir + "testEquals.xml");
        this.testEnhanceEquals("file:" + TestNcML.topDir + "testEquals.xml");
    }

    public void problem() throws IOException {
        this.testEquals("file:R:/testdata/2008TrainingWorkshop/tds/knmi/RAD___TEST_R_C_NL25PCP_L___20080720T000000_200807201T015500_0001_resampledto256x256.ncml");
        this.testEnhanceEquals("file:R:/testdata/2008TrainingWorkshop/tds/knmi/RAD___TEST_R_C_NL25PCP_L___20080720T000000_200807201T015500_0001_resampledto256x256.ncml");
    }

    private void testEquals(String ncmlLocation) throws IOException {
        System.out.println("testEquals");
        NetcdfDataset ncd = NcMLReader.readNcML((String)ncmlLocation, null);
        String locref = ncd.getReferencedFile().getLocation();
        NetcdfDataset ncdref = NetcdfDataset.openDataset((String)locref, (boolean)false, null);
        CompareNetcdf.compareFiles((NetcdfFile)ncd, (NetcdfFile)ncdref, (boolean)false, (boolean)true, (boolean)false);
        ncd.close();
        ncdref.close();
    }

    private void testEnhanceEquals(String ncmlLocation) throws IOException {
        System.out.println("testEnhanceEquals");
        NetcdfDataset ncml = NcMLReader.readNcML((String)ncmlLocation, null);
        NetcdfDataset ncmlEnhanced = new NetcdfDataset((NetcdfFile)ncml, true);
        String locref = ncml.getReferencedFile().getLocation();
        NetcdfDataset ncdrefEnhanced = NetcdfDataset.openDataset((String)locref, (boolean)true, null);
        CompareNetcdf.compareFiles((NetcdfFile)ncmlEnhanced, (NetcdfFile)ncdrefEnhanced, (boolean)false, (boolean)true, (boolean)false);
        ncml.close();
        ncdrefEnhanced.close();
    }
}

