/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestOffAggExistingTimeUnitsChange
extends TestCase {
    public TestOffAggExistingTimeUnitsChange(String name) {
        super(name);
    }

    public void testNamExtract() throws IOException, InvalidRangeException {
        String location = TestAll.cdmUnitTestDir + "ncml/nc/namExtract/test_agg.ncml";
        System.out.println(" TestOffAggExistingTimeUnitsChange.open " + location);
        NetcdfFile ncfile = NetcdfDataset.openFile((String)location, null);
        Variable v = ncfile.findVariable("time");
        assert (v != null);
        assert (v.getDataType() == DataType.DOUBLE);
        String units = v.getUnitsString();
        assert (units != null);
        assert (units.equals("hours since 2006-09-25T06:00:00Z"));
        int count = 0;
        Array data = v.read();
        NCdumpW.printArray((Array)data, (String)"time", (PrintWriter)new PrintWriter(System.out), null);
        while (data.hasNext()) {
            assert (TestAll.closeEnough(data.nextInt(), (count + 1) * 3));
            ++count;
        }
        ncfile.close();
    }

    public void testNarrGrib() throws IOException, InvalidRangeException {
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n <aggregation type='joinExisting' dimName='time' timeUnitsChange='true' >\n  <netcdf location='narr-a_221_20070411_0000_000.grb'/>\n  <netcdf location='narr-a_221_20070411_0300_000.grb'/>\n  <netcdf location='narr-a_221_20070411_0600_000.grb'/>\n </aggregation>\n</netcdf>";
        String location = "file:" + TestAll.cdmUnitTestDir + "ncml/nc/narr/";
        System.out.println(" TestOffAggExistingTimeUnitsChange.testNarrGrib=\n" + ncml);
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)location, null);
        Variable v = ncfile.findVariable("time");
        assert (v != null);
        assert (v.getDataType() == DataType.DOUBLE);
        String units = v.getUnitsString();
        assert (units != null);
        assert (units.equals("hours since 2007-04-11T00:00:00Z")) : units;
        int count = 0;
        Array data = v.read();
        NCdumpW.printArray((Array)data, (String)"time", (PrintWriter)new PrintWriter(System.out), null);
        while (data.hasNext()) {
            assert (data.nextInt() == count * 3);
            ++count;
        }
        ncfile.close();
    }
}

