/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class TestOffAggFmrcGrib
extends TestCase {
    private boolean showValues = false;

    public TestOffAggFmrcGrib(String name) {
        super(name);
    }

    public void testSimple() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='run' type='forecastModelRunCollection' timeUnitsChange='true'>\n    <scan location='" + TestAll.cdmUnitTestDir + "ncml/nc/nam_c20s/' suffix='.grib1' " + "dateFormatMark='NAM_CONUS_20km_surface_#yyyyMMdd_HHmm'/>\n" + "  </aggregation>\n" + "</netcdf>";
        System.out.printf("%s%n", xml);
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(xml), (String)"aggFmrcGrib", null);
        TestAll.showMem("TestAggFmrcGrib start ");
        int naggs = 8;
        this.testDimensions((NetcdfFile)ncfile, naggs, "time");
        this.testCoordVar((NetcdfFile)ncfile, 257);
        int[] runhours = new int[]{0, 12, 18, 24, 30, 4194, 4200, 4206};
        double[][] timevals = new double[][]{{0.0, 3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0}, {12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0, 93.0, 96.0}, {18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0, 93.0, 96.0, 99.0, 102.0}, {24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0, 93.0, 96.0, 99.0, 102.0, 105.0, 108.0, Double.NaN}, {30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0, 93.0, 96.0, 99.0, 102.0, 105.0, 108.0, 111.0, 114.0}, {4194.0, 4197.0, 4200.0, 4203.0, 4206.0, 4209.0, 4212.0, 4215.0, 4218.0, 4221.0, 4224.0, 4227.0, 4230.0, 4233.0, 4236.0, 4239.0, 4242.0, 4245.0, 4248.0, 4251.0, 4254.0, 4257.0, 4260.0, 4263.0, 4266.0, 4269.0, 4272.0, 4275.0, 4278.0}, {4200.0, 4203.0, 4206.0, 4209.0, 4212.0, 4215.0, 4218.0, 4221.0, 4224.0, 4227.0, 4230.0, 4233.0, 4236.0, 4239.0, 4242.0, 4245.0, 4248.0, 4251.0, 4254.0, 4257.0, 4260.0, 4263.0, 4266.0, 4269.0, 4272.0, 4275.0, 4278.0, 4281.0, 4284.0}, {4206.0, 4209.0, 4212.0, 4215.0, 4218.0, 4221.0, 4224.0, 4227.0, 4230.0, 4233.0, 4236.0, 4239.0, 4242.0, 4245.0, 4248.0, 4251.0, 4254.0, 4257.0, 4260.0, 4263.0, 4266.0, 4269.0, 4272.0, 4275.0, 4278.0, 4281.0, 4284.0, 4287.0, 4290.0}};
        this.testAggCoordVar((NetcdfFile)ncfile, naggs, new DateUnit("hours since 2006-03-15T18:00:00Z"), runhours);
        this.testTimeCoordVar((NetcdfFile)ncfile, naggs, 29, "time", timevals);
        System.out.println("TestAggForecastModel.testReadData ");
        this.testReadData((NetcdfFile)ncfile, naggs);
        TestAll.showMem("TestAggFmrcGrib end ");
        ncfile.close();
    }

    public void testRagged() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='run' type='forecastModelRunCollection' timeUnitsChange='true' fmrcDefinition='" + TestAll.cdmUnitTestDir + "ncml/nc/c20ss/fmrcDefinition.xml'>\n" + "    <scan location='" + TestAll.cdmUnitTestDir + "ncml/nc/c20ss/' suffix='.grib1' enhance='true' " + "dateFormatMark='NAM_CONUS_20km_selectsurface_#yyyyMMdd_HHmm'/>\n" + "  </aggregation>\n" + "</netcdf>";
        double[][] evals = new double[][]{{0.0, 3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN}, {6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0}, {12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN}, {18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 48.0, 51.0, 54.0, 57.0, 60.0, 63.0, 66.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 87.0, 90.0, 93.0, 96.0, 99.0, 102.0}};
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(xml), (String)"aggFmrcGribRunseq", null);
        int naggs = 4;
        String timeVarName = "time";
        String timeDimName = "time";
        this.testDimensions((NetcdfFile)ncfile, naggs, timeDimName);
        this.testCoordVar((NetcdfFile)ncfile, 257);
        int[] runtimes = new int[]{0, 6, 12, 18};
        this.testAggCoordVar((NetcdfFile)ncfile, naggs, new DateUnit("hours since 2006-07-29T18:00:00Z"), runtimes);
        this.testTimeCoordVar((NetcdfFile)ncfile, naggs, 29, timeVarName, evals);
        ncfile.close();
    }

    private void testDimensions(NetcdfFile ncfile, int nagg, String timeDimName) {
        Dimension latDim = ncfile.findDimension("x");
        assert (null != latDim);
        assert (latDim.getName().equals("x"));
        assert (latDim.getLength() == 369);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("y");
        assert (null != lonDim);
        assert (lonDim.getName().equals("y"));
        assert (lonDim.getLength() == 257);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension(timeDimName);
        assert (null != timeDim);
        assert (timeDim.getName().equals(timeDimName));
        assert (timeDim.getLength() == 29);
        Dimension runDim = ncfile.findDimension("run");
        assert (null != runDim);
        assert (runDim.getName().equals("run"));
        assert (runDim.getLength() == nagg) : nagg + " != " + runDim.getLength();
    }

    private void testCoordVar(NetcdfFile ncfile, int n) throws IOException {
        Variable lat = ncfile.findVariable("y");
        assert (null != lat);
        assert (lat.getName().equals("y"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == (long)n);
        assert (lat.getShape()[0] == n);
        assert (lat.getDataType() == DataType.DOUBLE);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("y")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("km"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == (long)n);
        assert (data.getShape()[0] == n);
        assert (data.getElementType() == Double.TYPE);
        IndexIterator dataI = data.getIndexIterator();
        assert (TestUtils.close(dataI.getDoubleNext(), -832.6983183345455));
        assert (TestUtils.close(dataI.getDoubleNext(), -812.3803183345456));
        assert (TestUtils.close(dataI.getDoubleNext(), -792.0623183345456));
    }

    private void testAggCoordVar(NetcdfFile ncfile, int nagg, DateUnit du, int[] runhours) {
        block14: {
            Variable time = ncfile.findVariable("run");
            assert (null != time);
            assert (time.getName().equals("run"));
            assert (time.getRank() == 1);
            assert (time.getSize() == (long)nagg);
            assert (time.getShape()[0] == nagg);
            assert (time.getDataType() == DataType.DOUBLE);
            DateFormatter formatter = new DateFormatter();
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == (long)nagg);
                assert (data.getShape()[0] == nagg);
                assert (data.getElementType() == Double.TYPE);
                NCdumpW.printArray((Array)data);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    assert (val == (double)runhours[count]);
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }

    private void testTimeCoordVar(NetcdfFile ncfile, int nagg, int ntimes, String timeVarName, double[][] timevals) throws Exception {
        Variable time = ncfile.findVariable(timeVarName);
        assert (null != time);
        assert (time.getName().equals(timeVarName));
        assert (time.getRank() == 2);
        assert (time.getSize() == (long)(nagg * ntimes));
        assert (time.getShape()[0] == nagg);
        assert (time.getShape()[1] == ntimes);
        assert (time.getDataType() == DataType.DOUBLE || time.getDataType() == DataType.INT);
        String units = time.getUnitsString();
        DateUnit du = new DateUnit(units);
        DateFormatter formatter = new DateFormatter();
        Array data = time.read();
        PrintWriter pw = new PrintWriter(System.out);
        NCdumpW.printArray((Array)data, (String)"timeCoords", (PrintWriter)pw, null);
        pw.flush();
        assert (data.getSize() == (long)(nagg * ntimes));
        assert (data.getShape()[0] == nagg);
        assert (data.getShape()[1] == ntimes);
        assert (data.getElementType() == Double.TYPE || data.getElementType() == Integer.TYPE);
        while (data.hasNext()) {
            double val = data.nextDouble();
            Date date = du.makeDate(val);
        }
        Index ima = data.getIndex();
        for (int run = 0; run < nagg; ++run) {
            for (int tidx = 0; tidx < ntimes; ++tidx) {
                double val = data.getDouble(ima.set(run, tidx));
                if (this.showValues) {
                    System.out.println(" run= " + run + " tidx= " + tidx + " val= " + val);
                }
                if (!Double.isNaN(val)) assert (val == timevals[run][tidx]) : "(" + run + "," + tidx + "): " + val + " != " + timevals[run][tidx];
            }
        }
    }

    private void testReadData(NetcdfFile ncfile, int nagg) throws IOException {
        Variable v = ncfile.findVariable("Pressure_surface");
        assert (null != v);
        assert (v.getName().equals("Pressure_surface"));
        assert (v.getRank() == 4);
        int[] shape = v.getShape();
        assert (shape[0] == nagg);
        assert (shape[1] == 29) : new Section(shape).toString();
        assert (shape[2] == 257) : new Section(shape).toString();
        assert (shape[3] == 369) : new Section(shape).toString();
        assert (v.getDataType() == DataType.FLOAT);
        assert (!v.isCoordinateVariable());
        assert (v.getDimension(0) == ncfile.findDimension("run"));
        assert (v.getDimension(1) == ncfile.findDimension("time"));
        assert (v.getDimension(2) == ncfile.findDimension("y"));
        assert (v.getDimension(3) == ncfile.findDimension("x"));
        Array data = v.read();
        assert (data.getRank() == 4);
        assert (data.getShape()[0] == nagg);
        assert (data.getShape()[1] == 29);
        assert (data.getShape()[2] == 257);
        assert (data.getShape()[3] == 369);
        double sum = MAMath.sumDoubleSkipMissingData((Array)data, (double)0.0);
        System.out.println(" sum= " + sum);
    }

    private void testReadSlice(NetcdfFile ncfile, int[] origin, int[] shape) throws IOException, InvalidRangeException {
        Variable v = ncfile.findVariable("P_sfc");
        Array data = v.read(origin, shape);
        assert (data.getRank() == 4);
        assert (data.getSize() == (long)(shape[0] * shape[1] * shape[2] * shape[3]));
        assert (data.getShape()[0] == shape[0]) : data.getShape()[0] + " " + shape[0];
        assert (data.getShape()[1] == shape[1]);
        assert (data.getShape()[2] == shape[2]);
        assert (data.getShape()[3] == shape[3]);
        assert (data.getElementType() == Float.TYPE);
    }

    private void testReadSlice(NetcdfFile ncfile) throws IOException, InvalidRangeException {
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{1, 11, 3, 4});
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{3, 2, 3, 2});
        this.testReadSlice(ncfile, new int[]{3, 5, 0, 0}, new int[]{1, 5, 3, 4});
        this.testReadSlice(ncfile, new int[]{3, 9, 0, 0}, new int[]{5, 2, 2, 3});
    }
}

