/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.NcMLReader;

public class TestOffAggFmrcMisc
extends TestCase {
    public TestOffAggFmrcMisc(String name) {
        super(name);
    }

    public void testScaling() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' enhance='true' >\n  <aggregation dimName='runtime' type='forecastModelRunCollection' timeUnitsChange='true'>\n    <scan location='D:/work/signell/efine' suffix='.nc' dateFormatMark='#yyyyMMddHH' enhance='true' />  </aggregation>\n</netcdf>";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(xml), (String)"aggFmrcScaling", null);
        VariableDS vs = (VariableDS)ncfile.findTopVariable("hs");
        Array data = vs.read("0,1,:,:)");
        while (data.hasNext()) {
            float val = data.nextFloat();
            if (!vs.isMissing((double)val)) assert ((double)val < 10.0) : val;
        }
        ncfile.close();
    }

    public void testScaling2() throws Exception {
        NetcdfFile ncfile = NetcdfDataset.acquireFile((String)"file:D:/work/signell/efine/fine.ncml", null);
        VariableDS vs = (VariableDS)ncfile.findTopVariable("hs");
        Array data = vs.read("0,1,:,:)");
        while (data.hasNext()) {
            float val = data.nextFloat();
            if (!vs.isMissing((double)val)) assert ((double)val < 10.0) : val;
        }
        ncfile.close();
    }
}

