/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.units.DateFormatter;

public class TestOffAggFmrcNetcdf
extends TestCase {
    public TestOffAggFmrcNetcdf(String name) {
        super(name);
    }

    public void testNUWGdatasets() throws IOException, InvalidRangeException {
        String filename = "file:" + TestAll.cdmUnitTestDir + "ncml/nc/ncmodels/aggFmrcNetcdf.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        System.out.println(" TestAggForecastModel.open " + filename);
        int nagg = 14;
        this.testDimensions((NetcdfFile)ncfile, nagg);
        this.testYCoordVar((NetcdfFile)ncfile);
        this.testRunCoordVar((NetcdfFile)ncfile, nagg);
        this.testTimeCoordVar((NetcdfFile)ncfile, nagg, 11);
        this.testReadData((NetcdfFile)ncfile, nagg);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
    }

    private void testDimensions(NetcdfFile ncfile, int nagg) {
        Dimension latDim = ncfile.findDimension("x");
        assert (null != latDim);
        assert (latDim.getName().equals("x"));
        assert (latDim.getLength() == 93);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("y");
        assert (null != lonDim);
        assert (lonDim.getName().equals("y"));
        assert (lonDim.getLength() == 65);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("run");
        assert (null != timeDim);
        assert (timeDim.getName().equals("run"));
        assert (timeDim.getLength() == nagg) : timeDim.getLength();
    }

    private void testYCoordVar(NetcdfFile ncfile) throws IOException {
        Variable lat = ncfile.findVariable("y");
        assert (null != lat);
        assert (lat.getName().equals("y"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 65L);
        assert (lat.getShape()[0] == 65);
        assert (lat.getDataType() == DataType.DOUBLE);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("y")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("km"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 65L);
        assert (data.getShape()[0] == 65);
        assert (data.getElementType() == Double.TYPE);
        IndexIterator dataI = data.getIndexIterator();
        assert (TestUtils.close(dataI.getDoubleNext(), -832.6983183345455));
        assert (TestUtils.close(dataI.getDoubleNext(), -751.4273183345456));
        assert (TestUtils.close(dataI.getDoubleNext(), -670.1563183345455));
    }

    private void testRunCoordVar(NetcdfFile ncfile, int nagg) {
        block14: {
            Variable time = ncfile.findVariable("run");
            assert (null != time);
            assert (time.getName().equals("run"));
            assert (time.getRank() == 1);
            assert (time.getSize() == (long)nagg);
            assert (time.getShape()[0] == nagg);
            assert (time.getDataType() == DataType.DOUBLE);
            DateFormatter formatter = new DateFormatter();
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == (long)nagg);
                assert (data.getShape()[0] == nagg);
                assert (data.getElementType() == Double.TYPE);
                NCdumpW.printArray((Array)data);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    assert (val == (double)(count * 12));
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }

    private void testTimeCoordVar(NetcdfFile ncfile, int nagg, int noff) throws IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 2);
        assert (time.getSize() == (long)(nagg * noff));
        assert (time.getShape()[0] == nagg);
        assert (time.getShape()[1] == noff);
        assert (time.getDataType() == DataType.DOUBLE);
        Array data = time.read();
        assert (data.getRank() == 2);
        assert (data.getSize() == (long)(nagg * noff));
        assert (data.getShape()[0] == nagg);
        assert (data.getShape()[1] == noff);
        assert (data.getElementType() == Double.TYPE);
        double[][] result = new double[][]{{0.0, 6.0, 12.0, 18.0, 24.0, 30.0, 36.0, 42.0, 48.0, 54.0, 60.0}, {12.0, 18.0, 24.0, 30.0, 36.0, 42.0, 48.0, 54.0, 60.0, 66.0, 72.0}, {24.0, 30.0, 36.0, 42.0, 48.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0}, {36.0, 42.0, 48.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0, 90.0, 96.0}, {48.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0, 90.0, 96.0, 102.0, 108.0}, {60.0, 66.0, 72.0, 78.0, 84.0, 90.0, 96.0, 102.0, 108.0, 114.0, 120.0}, {72.0, 78.0, 84.0, 90.0, 96.0, 102.0, 108.0, 114.0, 120.0, 126.0, 132.0}, {84.0, 90.0, 96.0, 102.0, 108.0, 114.0, 120.0, 126.0, 132.0, 138.0, 144.0}, {96.0, 102.0, 108.0, 114.0, 120.0, 126.0, 132.0, 138.0, 144.0, 150.0, 156.0}, {108.0, 114.0, 120.0, 126.0, 132.0, 138.0, 144.0, 150.0, 156.0, 162.0, 168.0}, {120.0, 126.0, 132.0, 138.0, 144.0, 150.0, 156.0, 162.0, 168.0, 174.0, 180.0}, {132.0, 138.0, 144.0, 150.0, 156.0, 162.0, 168.0, 174.0, 180.0, 186.0, 192.0}, {144.0, 150.0, 156.0, 162.0, 168.0, 174.0, 180.0, 186.0, 192.0, 198.0, 204.0}, {156.0, 162.0, 168.0, 174.0, 180.0, 186.0, 192.0, 198.0, 204.0, 210.0, 216.0}};
        Index ima = data.getIndex();
        for (int i = 0; i < nagg; ++i) {
            for (int j = 0; j < noff; ++j) {
                double val = data.getDouble(ima.set(i, j));
                assert (TestAll.closeEnough(val, result[i][j]));
            }
        }
    }

    private void testReadData(NetcdfFile ncfile, int nagg) throws IOException {
        Variable v = ncfile.findVariable("P_sfc");
        assert (null != v);
        assert (v.getName().equals("P_sfc"));
        assert (v.getRank() == 4);
        assert (v.getShape()[0] == nagg);
        assert (v.getShape()[1] == 11);
        assert (v.getShape()[2] == 65);
        assert (v.getShape()[3] == 93);
        assert (v.getDataType() == DataType.FLOAT);
        assert (!v.isCoordinateVariable());
        assert (v.getDimension(0) == ncfile.findDimension("run"));
        assert (v.getDimension(1) == ncfile.findDimension("time"));
        assert (v.getDimension(2) == ncfile.findDimension("y"));
        assert (v.getDimension(3) == ncfile.findDimension("x"));
        Array data = v.read();
        assert (data.getRank() == 4);
        assert (data.getShape()[0] == nagg);
        assert (data.getShape()[1] == 11);
        assert (data.getShape()[2] == 65);
        assert (data.getShape()[3] == 93);
        double sum = MAMath.sumDoubleSkipMissingData((Array)data, (double)0.0);
        System.out.println(" sum= " + sum);
    }

    private void testReadSlice(NetcdfFile ncfile, int[] origin, int[] shape) throws IOException, InvalidRangeException {
        Variable v = ncfile.findVariable("P_sfc");
        Array data = v.read(origin, shape);
        assert (data.getRank() == 4);
        assert (data.getSize() == (long)(shape[0] * shape[1] * shape[2] * shape[3]));
        assert (data.getShape()[0] == shape[0]) : data.getShape()[0] + " " + shape[0];
        assert (data.getShape()[1] == shape[1]);
        assert (data.getShape()[2] == shape[2]);
        assert (data.getShape()[3] == shape[3]);
        assert (data.getElementType() == Float.TYPE);
    }

    private void testReadSlice(NetcdfFile ncfile) throws IOException, InvalidRangeException {
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{1, 11, 3, 4});
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{3, 2, 3, 2});
        this.testReadSlice(ncfile, new int[]{3, 5, 0, 0}, new int[]{1, 5, 3, 4});
        this.testReadSlice(ncfile, new int[]{3, 9, 0, 0}, new int[]{5, 2, 2, 3});
    }
}

