/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestOffAggFmrcScan2
extends TestCase {
    public TestOffAggFmrcScan2(String name) {
        super(name);
    }

    public void testOpen() throws Exception {
        String dataDir = TestAll.cdmUnitTestDir + "rtmodels/";
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='run' type='forecastModelRunSingleCollection' timeUnitsChange='true' >\n    <scanFmrc location='" + dataDir + "' regExp='.*_nmm\\.GrbF[0-9]{5}$'\n" + "           runDateMatcher='yyMMddHH#_nmm.GrbF#'\n" + "           forecastOffsetMatcher='#_nmm.GrbF#HHH'/>\n" + "  </aggregation>\n" + "</netcdf>";
        String filename = "file:./" + TestNcML.topDir + "offsite/aggFmrcScan2.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)filename, null);
        System.out.println(" TestAggForecastModel.open " + filename);
        System.out.println("file=" + ncfile);
        TestAll.readAll((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testOpenNomads() throws Exception {
        String dataDir = TestAll.cdmUnitTestDir + "fmrc/nomads/";
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='run' type='forecastModelRunSingleCollection' timeUnitsChange='true' >\n    <scanFmrc location='" + dataDir + "' suffix='.grb'\n" + "           runDateMatcher='#gfs_3_#yyyyMMdd_HH'\n" + "           forecastOffsetMatcher='HHH#.grb#'/>\n" + "  </aggregation>\n" + "</netcdf>";
        String filename = "file:./" + TestNcML.topDir + "offsite/aggFmrcNomads.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)filename, null);
        System.out.println(" TestAggForecastModel.open " + filename);
        System.out.println("file=" + ncfile);
        TestAll.readAll((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void utestMargolis() throws IOException, InvalidRangeException {
        String dataDir = TestAll.cdmUnitTestDir + "nomads/gfs-hi/";
        GridDataset gridDataset = GridDataset.open((String)"D:/AStest/margolis/grib2ncdf.ncml");
        GeoGrid grid = gridDataset.findGridByName("Turbulence_SIGMET_AIRMET");
        System.out.println("Grid= " + grid + " section=" + new Section(grid.getShape()));
        System.out.println(" coordSys= " + grid.getCoordinateSystem());
        GeoGrid subset = (GeoGrid)grid.makeSubset(new Range(0, 0), null, new Range(1, 1), null, null, null);
        System.out.println("subset= " + subset + " section=" + new Section(subset.getShape()));
        System.out.println(" coordSys= " + subset.getCoordinateSystem());
        gridDataset.close();
    }

    public static void main(String[] args) throws IOException {
        String fname = "D:/work/signell/rtofs/rtofs.ncml";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)fname);
        TestAll.readAll((NetcdfFile)ncfile);
        ncfile.close();
    }
}

