/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestOffAggForecastModel
extends TestCase {
    private int nruns = 15;
    private int nfore = 11;
    static String dataDir = TestAll.cdmUnitTestDir + "ncmodels/";
    static String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='runtime' type='forecastModelRunCollection' recheckEvery='0 sec'>\n    <scan location='" + dataDir + "' suffix='.nc' dateFormatMark='NAM_CONUS_80km_#yyyyMMdd_HHmm' enhance='true'/>\n" + "  </aggregation>\n" + "</netcdf>";

    public TestOffAggForecastModel(String name) {
        super(name);
    }

    public void testForecastModel() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "offsite/aggForecastModel.xml";
        System.out.println(" TestOffAggForecastModel.testForecastModel=\n" + ncml);
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)filename, null);
        this.testDimensions((NetcdfFile)ncfile, this.nruns);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile, this.nruns);
        this.testReadData((NetcdfFile)ncfile, this.nruns, this.nfore);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void utestForecastModelExtend() throws IOException, InvalidRangeException {
        boolean ok;
        String filename = "file:./" + TestNcML.topDir + "offsite/aggForecastModel.xml";
        String newModel = dataDir + "NAM_CONUS_80km_20051212_1200.nc";
        String newModelsave = dataDir + "NAM_CONUS_80km_20051212_1200.nc.save";
        File newModelFile = new File(newModel);
        File newModelFileSave = new File(newModelsave);
        if (newModelFile.exists() && !newModelFileSave.exists()) {
            ok = newModelFile.renameTo(newModelFileSave);
            if (!ok) {
                throw new IOException("cant rename file " + newModelFile);
            }
        } else if (!newModelFile.exists() && newModelFileSave.exists()) {
            System.out.println("already renamed");
        } else {
            if (!newModelFile.exists() && !newModelFileSave.exists()) {
                throw new IOException("missing " + newModelFile.getPath());
            }
            if (newModelFile.exists() && newModelFileSave.exists() && !(ok = newModelFile.delete())) {
                throw new IOException("cant delete file " + newModelFile.getPath());
            }
        }
        System.out.println(" TestOffAggForecastModel.testForecastModel=\n" + ncml);
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)filename, null);
        System.out.println(" TestAggForecastModel.open " + filename);
        this.testDimensions((NetcdfFile)ncfile, this.nruns - 1);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile, this.nruns - 1);
        this.testReadData((NetcdfFile)ncfile, this.nruns - 1, this.nfore);
        this.testReadSlice((NetcdfFile)ncfile);
        boolean ok2 = newModelFileSave.renameTo(newModelFile);
        if (!ok2) {
            throw new IOException("cant rename file");
        }
        ncfile.sync();
        this.testDimensions((NetcdfFile)ncfile, this.nruns);
        this.testCoordVar((NetcdfFile)ncfile);
        this.testAggCoordVar((NetcdfFile)ncfile, this.nruns);
        this.testReadData((NetcdfFile)ncfile, this.nruns, this.nfore);
        this.testReadSlice((NetcdfFile)ncfile);
        ncfile.close();
    }

    public void testDimensions(NetcdfFile ncfile, int nagg) {
        Dimension latDim = ncfile.findDimension("x");
        assert (null != latDim);
        assert (latDim.getName().equals("x"));
        assert (latDim.getLength() == 93);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("y");
        assert (null != lonDim);
        assert (lonDim.getName().equals("y"));
        assert (lonDim.getLength() == 65);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("run");
        assert (null != timeDim);
        assert (timeDim.getName().equals("run"));
        assert (timeDim.getLength() == nagg) : nagg + " != " + timeDim.getLength();
    }

    public void testCoordVar(NetcdfFile ncfile) throws IOException {
        Variable lat = ncfile.findVariable("y");
        assert (null != lat);
        assert (lat.getName().equals("y"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 65L);
        assert (lat.getShape()[0] == 65);
        assert (lat.getDataType() == DataType.DOUBLE);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("y")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("km"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        Array data = lat.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 65L);
        assert (data.getShape()[0] == 65);
        assert (data.getElementType() == Double.TYPE);
        IndexIterator dataI = data.getIndexIterator();
        assert (TestUtils.close(dataI.getDoubleNext(), -832.6983183345455));
        assert (TestUtils.close(dataI.getDoubleNext(), -751.4273183345456));
        assert (TestUtils.close(dataI.getDoubleNext(), -670.1563183345455));
    }

    public void testAggCoordVar(NetcdfFile ncfile, int nagg) {
        block15: {
            Variable time = ncfile.findVariable("run");
            assert (null != time);
            assert (time.getName().equals("run"));
            assert (time.getRank() == 1);
            assert (time.getSize() == (long)nagg);
            assert (time.getShape()[0] == nagg);
            assert (time.getDataType() == DataType.DOUBLE);
            assert (time.isCoordinateVariable());
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == (long)nagg);
                assert (data.getShape()[0] == nagg);
                assert (data.getElementType() == Double.TYPE);
                NCdumpW.printArray((Array)data);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    assert (val == (double)(count * 12));
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
    }

    public void testReadData(NetcdfFile ncfile, int nagg, int nfore) throws IOException {
        Variable v = ncfile.findVariable("P_sfc");
        assert (null != v);
        assert (v.getName().equals("P_sfc"));
        assert (v.getRank() == 4);
        assert (v.getShape()[0] == nagg);
        assert (v.getShape()[1] == nfore) : v.getShape()[1];
        assert (v.getShape()[2] == 65);
        assert (v.getShape()[3] == 93);
        assert (v.getDataType() == DataType.FLOAT);
        assert (!v.isCoordinateVariable());
        assert (v.getDimension(0) == ncfile.findDimension("run"));
        assert (v.getDimension(1) == ncfile.findDimension("time"));
        assert (v.getDimension(2) == ncfile.findDimension("y"));
        assert (v.getDimension(3) == ncfile.findDimension("x"));
        Array data = v.read();
        assert (data.getRank() == 4);
        assert (data.getShape()[0] == nagg);
        assert (data.getShape()[1] == nfore);
        assert (data.getShape()[2] == 65);
        assert (data.getShape()[3] == 93);
        assert (data.getElementType() == Float.TYPE);
    }

    public void testReadSlice(NetcdfFile ncfile, int[] origin, int[] shape) throws IOException, InvalidRangeException {
        Variable v = ncfile.findVariable("P_sfc");
        Array data = v.read(origin, shape);
        assert (data.getRank() == 4);
        assert (data.getSize() == (long)(shape[0] * shape[1] * shape[2] * shape[3]));
        assert (data.getShape()[0] == shape[0]);
        assert (data.getShape()[1] == shape[1]);
        assert (data.getShape()[2] == shape[2]);
        assert (data.getShape()[3] == shape[3]);
        assert (data.getElementType() == Float.TYPE);
    }

    public void testReadSlice(NetcdfFile ncfile) throws IOException, InvalidRangeException {
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{14, 11, 3, 4});
        this.testReadSlice(ncfile, new int[]{0, 0, 0, 0}, new int[]{4, 2, 3, 2});
        this.testReadSlice(ncfile, new int[]{5, 0, 0, 0}, new int[]{3, 10, 3, 4});
        this.testReadSlice(ncfile, new int[]{10, 0, 0, 0}, new int[]{4, 10, 2, 3});
    }
}

