/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.util.DiskCache2;

public class TestOffExistingSync
extends TestCase {
    String dataDir = "//zero/share/testdata/image/testSync/";

    public TestOffExistingSync(String name) {
        super(name);
    }

    public void testTiming() throws IOException, InterruptedException {
        String filename = "file:C:/TEMP/aggManyFiles/TestAggManyFiles.ncml";
        Aggregation.setPersistenceCache((DiskCache2)new DiskCache2("/.unidata/cachePersist", true, 43200, 60));
        long start = System.currentTimeMillis();
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        long ending = System.currentTimeMillis();
        double secs = 0.001 * (double)(ending - start);
        System.out.println("that took " + secs + " secs");
        ncfile.close();
    }

    public void testSync() throws IOException, InterruptedException {
        this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        String filename = "file:./" + TestNcML.topDir + "offsite/aggNewSync.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile, 7);
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        Thread.sleep(2000L);
        ncfile.sync();
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        ncfile.close();
    }

    public void testSyncRemove() throws IOException, InterruptedException {
        String filename = "file:./" + TestNcML.topDir + "offsite/aggNewSync.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        System.out.println("");
        this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        Thread.sleep(2000L);
        ncfile.sync();
        this.testAggCoordVar((NetcdfFile)ncfile, 7);
        ncfile.close();
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
    }

    public void testAggCoordVar(NetcdfFile ncfile, int n) throws IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == (long)n) : time.getSize();
        assert (time.getShape()[0] == n);
        assert (time.getDataType() == DataType.STRING);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        Array data = time.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == (long)n);
        assert (data.getShape()[0] == n);
        assert (data.getElementType() == String.class);
        String prev = null;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            String curr = (String)dataI.getObjectNext();
            System.out.println(" coord=" + curr);
            assert (prev == null || prev.compareTo(curr) < 0);
            prev = curr;
        }
    }

    void move(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            f.renameTo(new File(filename + ".save"));
        }
    }

    void moveBack(String filename) {
        File f = new File(filename + ".save");
        f.renameTo(new File(filename));
    }

    public static void main(String[] args) throws IOException {
        String dirName = "C:/temp/aggManyFiles/";
        int n = 20000;
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdir();
        }
        int count = 0;
        String stub = "Test";
        NetcdfFile org = NetcdfFile.open((String)"C:/data/CM2006172_180000h_u25h.nc");
        for (int i = 0; i < n; ++i) {
            String fileOut = dirName + stub + i + ".nc";
            Variable v = org.findVariable("time");
            ArrayDouble.D1 data = (ArrayDouble.D1)v.read();
            data.set(0, (double)count++);
            v.setCachedData((Array)data, false);
            NetcdfFile result = FileWriter.writeToFile((NetcdfFile)org, (String)fileOut);
            result.close();
        }
    }
}

