/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TestDataset;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.util.StringUtil;

public class TestOffNcMLWriteRead
extends TestCase {
    static boolean showFiles = true;
    static boolean showCompare = false;
    static boolean showEach = false;
    private ArrayList<String> files;
    private String datadir = TestAll.testdataDir + "grid/netcdf/";

    public TestOffNcMLWriteRead(String name) {
        super(name);
    }

    public void setUp() {
        this.files = new ArrayList();
        this.files.add(this.datadir + "atd-radar/rgg.20020411.000000.lel.ll.nc");
        this.files.add(this.datadir + "awips/19981109_1200.nc");
        this.files.add(this.datadir + "cf/ccsm2.nc");
        this.files.add(this.datadir + "coards/cldc.mean.nc");
        this.files.add(this.datadir + "csm/o3monthly.nc");
        this.files.add(this.datadir + "gdv/OceanDJF.nc");
        this.files.add(this.datadir + "gief/coamps.wind_uv.nc");
        this.files.add(this.datadir + "mars/temp_air_01082000.nc");
        this.files.add(this.datadir + "nuwg/eta.nc");
        this.files.add(this.datadir + "nuwg/ocean.nc");
        this.files.add(this.datadir + "wrf/wrfout_v2_Lambert.nc");
        this.files.add(this.datadir + "atd-radar/SPOL_3Volumes.nc");
    }

    public void testReadAsNcfile() throws Exception {
        for (String s : this.files) {
            this.convertAsNcfile(s, false);
        }
    }

    public void testReadAsNcfileExplicit() throws Exception {
        for (String s : this.files) {
            this.convertAsNcfileExplicit(s, false);
        }
    }

    public void testReadAsNcfileWithRecords() throws Exception {
        for (String s : this.files) {
            this.convertAsNcfile(s, true);
        }
    }

    public void testReadAsNcdataset() throws Exception {
        for (String s : this.files) {
            this.convertAsNcdataset(s, false);
        }
    }

    public void testReadAsNcdatasetWithRecords() throws Exception {
        for (String s : this.files) {
            this.convertAsNcdataset(s, true);
        }
    }

    public void utestOne() throws Exception {
        this.convertAsNcdataset("C:/data/conventions/nuwg/ocean.nc", false);
    }

    void readAllDir(String dirName) throws Exception {
        File[] allFiles;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        for (File allFile : allFiles = allDir.listFiles()) {
            String name = allFile.getAbsolutePath();
            this.convertAsNcfile(name, false);
        }
        for (File f : allFiles) {
            if (!f.isDirectory()) continue;
            this.readAllDir(f.getAbsolutePath());
        }
    }

    private void convertAsNcfile(String location, boolean useRecords) throws IOException {
        String ncmlOut;
        NetcdfFile org_ncd;
        block6: {
            location = StringUtil.replace((String)location, (char)'\\', (String)"/");
            if (showFiles) {
                System.out.println("-----------");
                System.out.println(" input filename= " + location);
            }
            org_ncd = NetcdfDataset.acquireFile((String)location, null);
            if (useRecords) {
                org_ncd.sendIospMessage((Object)"AddRecordStructure");
            }
            NcMLWriter writer = new NcMLWriter();
            File writeDir = new File(TestDataset.writeDir);
            writeDir.mkdirs();
            int pos = location.lastIndexOf("/");
            String filename = location.substring(pos + 1);
            ncmlOut = TestDataset.writeDir + filename + ".ncml";
            if (showFiles) {
                System.out.println(" output filename= " + ncmlOut);
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ncmlOut, false));
                writer.writeXML(org_ncd, (OutputStream)out, null);
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        NetcdfFile new_ncd = NetcdfDataset.acquireFile((String)ncmlOut, null);
        if (useRecords) {
            new_ncd.sendIospMessage((Object)"AddRecordStructure");
        }
        CompareNetcdf.compareFiles((NetcdfFile)org_ncd, (NetcdfFile)new_ncd);
        org_ncd.close();
        new_ncd.close();
    }

    private void convertAsNcfileExplicit(String location, boolean useRecords) throws IOException {
        String ncmlOut;
        NetcdfFile org_ncd;
        block6: {
            location = StringUtil.replace((String)location, (char)'\\', (String)"/");
            if (showFiles) {
                System.out.println("-----------");
                System.out.println(" input filename= " + location);
            }
            org_ncd = NetcdfDataset.acquireFile((String)location, null);
            if (useRecords) {
                org_ncd.sendIospMessage((Object)"AddRecordStructure");
            }
            NcMLWriter writer = new NcMLWriter();
            File writeDir = new File(TestDataset.writeDir);
            writeDir.mkdirs();
            int pos = location.lastIndexOf("/");
            String filename = location.substring(pos + 1);
            ncmlOut = TestDataset.writeDir + filename + ".ncml";
            if (showFiles) {
                System.out.println(" output filename= " + ncmlOut);
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ncmlOut, false));
                writer.writeXMLexplicit(org_ncd, (OutputStream)out, null);
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        NetcdfFile new_ncd = NetcdfDataset.acquireFile((String)ncmlOut, null);
        if (useRecords) {
            new_ncd.sendIospMessage((Object)"AddRecordStructure");
        }
        CompareNetcdf.compareFiles((NetcdfFile)org_ncd, (NetcdfFile)new_ncd);
        org_ncd.close();
        new_ncd.close();
    }

    private void convertAsNcdataset(String location, boolean useRecords) throws IOException {
        String ncmlOut;
        NetcdfDataset org_ncd;
        block6: {
            location = StringUtil.replace((String)location, (char)'\\', (String)"/");
            org_ncd = NetcdfDataset.openDataset((String)location, (boolean)false, null);
            if (useRecords) {
                org_ncd.sendIospMessage((Object)"AddRecordStructure");
            }
            NcMLWriter writer = new NcMLWriter();
            if (showFiles) {
                System.out.println("-----------");
                System.out.println("DS input filename= " + location);
            }
            int pos = location.lastIndexOf("/");
            String filename = location.substring(pos + 1);
            ncmlOut = TestDataset.writeDir + filename + ".ncml";
            if (showFiles) {
                System.out.println(" output filename= " + ncmlOut);
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ncmlOut, false));
                writer.writeXML((NetcdfFile)org_ncd, (OutputStream)out, null);
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        NetcdfDataset new_ncd = NetcdfDataset.openDataset((String)ncmlOut, (boolean)false, null);
        if (useRecords) {
            new_ncd.sendIospMessage((Object)"AddRecordStructure");
        }
        CompareNetcdf.compareFiles((NetcdfFile)org_ncd, (NetcdfFile)new_ncd);
        org_ncd.close();
        new_ncd.close();
    }
}

