/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestValuesFromAttribute
extends TestCase {
    String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' location='file:src/test/data/ncml/nc/lflx.mean.nc'>\n   <variable name='titleAsVariable' type='String' shape=''>\n     <values fromAttribute='title'/>\n   </variable>\n   <variable name='titleAsVariable2' type='String' shape=''>\n     <values fromAttribute='@title'/>\n   </variable>\n   <variable name='VariableAttribute' type='double' shape='2'>\n     <values fromAttribute='time@actual_range'/>\n   </variable>\n</netcdf>";

    public TestValuesFromAttribute(String name) {
        super(name);
    }

    public void testValuesFromAttribute() throws IOException, InvalidRangeException {
        String filename = "file:./" + TestNcML.topDir + "TestValuesFromAttribute.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(this.ncml), (String)filename, null);
        System.out.println(" TestNcmlAggExisting.open " + filename + "\n" + ncfile);
        Variable newVar = ncfile.findVariable("titleAsVariable");
        assert (null != newVar);
        assert (newVar.getName().equals("titleAsVariable"));
        assert (newVar.getRank() == 0);
        assert (newVar.getSize() == 1L);
        assert (newVar.getDataType() == DataType.STRING);
        Array data = newVar.read();
        assert (data.getElementType() == String.class);
        Object val = data.getObject(0);
        assert (val instanceof String);
        assert (val.equals("COADS 1-degree Equatorial Enhanced"));
        newVar = ncfile.findVariable("titleAsVariable2");
        assert (null != newVar);
        assert (newVar.getName().equals("titleAsVariable2"));
        assert (newVar.getRank() == 0);
        assert (newVar.getSize() == 1L);
        assert (newVar.getDataType() == DataType.STRING);
        data = newVar.read();
        assert (data.getElementType() == String.class);
        val = data.getObject(0);
        assert (val instanceof String);
        assert (val.equals("COADS 1-degree Equatorial Enhanced"));
        newVar = ncfile.findVariable("VariableAttribute");
        assert (null != newVar);
        assert (newVar.getName().equals("VariableAttribute"));
        assert (newVar.getRank() == 1);
        assert (newVar.getSize() == 2L);
        assert (newVar.getDataType() == DataType.DOUBLE);
        data = newVar.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 2L);
        assert (data.getElementType() == Double.TYPE);
        double[] result = new double[]{715511.0, 729360.0};
        for (int i = 0; i < result.length; ++i) {
            assert (result[i] == data.getDouble(i));
        }
        ncfile.close();
    }
}

