/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import thredds.catalog.query.Station;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.thredds.DqcRadarDatasetCollection;
import ucar.nc2.units.DateUnit;
import ucar.unidata.util.DateSelection;

public class TestDqcStationaryRadarDataset
extends TestCase {
    StringBuffer errlog = new StringBuffer();
    String dqc_location = "http://motherlode.ucar.edu:8080/thredds/idd/radarLevel2";
    DqcRadarDatasetCollection ds;
    List stns;

    public void testDqc() throws IOException {
        try {
            this.ds = DqcRadarDatasetCollection.factory((String)"test", (String)this.dqc_location, (StringBuffer)this.errlog);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + "\n");
        }
        this.stns = this.ds.getStations();
        assert (null != this.stns);
        if (this.errlog.length() > 0) {
            System.out.println(" errs= " + this.errlog);
        } else {
            System.out.println("success\n");
        }
    }

    public void testDqcRadarStation() throws IOException {
        if (this.ds == null) {
            this.testDqc();
        }
        Station stn = this.ds.getStation("KFTG");
        assert (null != this.stns);
        long now = System.currentTimeMillis();
        long yday0 = now - 129600000L;
        long yday1 = now - 108000000L;
        Date ts0 = new Date(yday0);
        Date ts1 = new Date(yday1);
        DateSelection dateS = new DateSelection(ts0, ts1);
        dateS.setInterval(0.0);
        dateS.setRoundTo(0.0);
        dateS.setPreRange(0.0);
        dateS.setPostRange(0.0);
        ArrayList absList2 = this.ds.getRadarStationTimes(stn.getValue(), ts0, ts1);
        assert (null != absList2);
        ArrayList ulist = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != ulist);
        dateS.setInterval(3600000.0);
        ulist = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != ulist);
        ArrayList tlist = this.ds.getRadarStationTimes(stn.getValue(), null, null);
        assert (null != tlist);
        Date ts = DateUnit.getStandardOrISO((String)((String)tlist.get(1)));
        assert (null != ts);
        URI stURL = this.ds.getRadarDatasetURI(stn.getValue(), ts);
        assert (null != stURL);
    }

    public void testDqcRadarDatasetURIs() throws IOException {
        if (this.ds == null) {
            this.testDqc();
        }
        Station stn = (Station)this.stns.get(1);
        assert (null != stn);
        DateSelection dateS = new DateSelection();
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        ArrayList ulist = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != ulist);
        ArrayList tlist = this.ds.getRadarStationTimes(stn.getValue(), null, null);
        assert (null != tlist);
        ArrayList data = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != data);
        dateS.setPreRange(200000.0);
        dateS.setPostRange(200000.0);
        ArrayList data1 = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != data1);
        dateS.setPostRange(0.0);
        ArrayList data2 = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != data2);
        dateS.setPreRange(0.0);
        dateS.setPostRange(200000.0);
        ArrayList data3 = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != data3);
        dateS.setPreRange(100000.0);
        dateS.setPostRange(100000.0);
        ArrayList data4 = this.ds.getDataURIs(stn.getValue(), dateS);
        assert (null != data4);
    }

    public void testDqcRadarDatasetATimes() throws IOException {
        if (this.ds == null) {
            this.testDqc();
        }
        Station stn = this.ds.getStation("KFTG");
        assert (null != stn);
        ArrayList tlist = this.ds.getRadarStationTimes(stn.getValue(), null, null);
        assert (null != tlist);
        Date ts = DateUnit.getStandardOrISO((String)((String)tlist.get(1)));
        assert (null != ts);
        URI stURL = this.ds.getRadarDatasetURI(stn.getValue(), ts);
        assert (null != stURL);
        RadialDatasetSweep rds = this.ds.getRadarDataset(stn.getValue(), ts);
        assert (null != rds);
    }

    public void testDqcRadarDatasetTimesRange() throws IOException {
        if (this.ds == null) {
            this.testDqc();
        }
        Station stn = this.ds.getStation("KFTG");
        assert (null != stn);
        ArrayList rList = this.ds.getRadarStationTimes(stn.getValue(), null, null);
        assert (null != rList);
        Date ts0 = DateUnit.getStandardOrISO((String)((String)rList.get(5)));
        Date ts1 = DateUnit.getStandardOrISO((String)((String)rList.get(1)));
        ArrayList subList = this.ds.getRadarStationTimes(stn.getValue(), ts0, ts1);
        assert (null != subList);
        Iterator it1 = subList.iterator();
        while (it1.hasNext()) {
            Date result = DateUnit.getStandardOrISO((String)((String)it1.next()));
            assert (null != result);
        }
        long now = System.currentTimeMillis();
        long yday0 = now - 129600000L;
        long yday1 = now - 86400000L;
        ts0 = new Date(yday0);
        ts1 = new Date(yday1);
        DateSelection dateS = new DateSelection(ts0, ts1);
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        ArrayList data = this.ds.getData(stn.getValue(), dateS);
        assert (null != data);
        for (RadialDatasetSweep rds : data) {
            assert (null != rds);
        }
    }

    public void testDqcRadarDatasetATimesGetData() throws IOException {
        if (this.ds == null) {
            this.testDqc();
        }
        Station stn = this.ds.getStation("KFTG");
        assert (null != stn);
        ArrayList tlist = this.ds.getRadarStationTimes(stn.getValue(), null, null);
        assert (null != tlist);
        int sz = tlist.size();
        Date ts = DateUnit.getStandardOrISO((String)((String)tlist.get(1)));
        URI stURL = this.ds.getRadarDatasetURI(stn.getValue(), ts);
        assert (null != stURL);
        Date tsn = DateUnit.getStandardOrISO((String)((String)tlist.get(0)));
        Date ts1 = DateUnit.getStandardOrISO((String)((String)tlist.get(sz - 1)));
        DateSelection dateS = new DateSelection(ts1, tsn);
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        ArrayList dList = this.ds.getDataURIs("KABX", dateS);
        for (URI result : dList) {
            assert (null != result);
        }
    }

    public String getISOTime(Date d) {
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return isoDateTimeFormat.format(d);
    }
}

