/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Date;
import junit.framework.TestCase;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public class TestDate
extends TestCase {
    private static final boolean debug = true;
    private static final boolean debug2 = true;
    private DateFormatter formatter = new DateFormatter();

    public TestDate(String name) {
        super(name);
    }

    void doTime2(double value, String name, boolean ok) {
        Unit uu;
        Unit timeUnit;
        UnitFormat format = UnitFormatManager.instance();
        try {
            timeUnit = format.parse("secs since 1970-01-01 00:00:00");
        }
        catch (Exception e) {
            System.out.println("SimpleUnit initialization failed " + e);
            return;
        }
        try {
            uu = format.parse(name);
        }
        catch (Exception e) {
            System.out.println("Parse " + name + " got Exception " + e);
            return;
        }
        System.out.println("isCompatible=" + uu.isCompatible(timeUnit));
        try {
            System.out.println("convert " + uu.convertTo(value, timeUnit));
        }
        catch (Exception e) {
            System.out.println("convert " + name + " got Exception " + e);
            return;
        }
    }

    public void testStandardDate() {
        Date d = DateUnit.getStandardDate((String)"25 days since 1985-02-02 00:00:00");
        System.out.println(" d=" + this.formatter.toDateTimeStringISO(d));
        d = DateUnit.getStandardDate((String)"1000.0 secs since 1985-02-02 12:00:00");
        System.out.println(" d=" + this.formatter.toDateTimeStringISO(d));
        d = DateUnit.getStandardDate((String)"1.0 secs since 1985-02-02 12:00:00");
        System.out.println(" d=" + this.formatter.toDateTimeStringISO(d));
    }

    public void utestStandardDatePrecision() {
        Date d = DateUnit.getStandardDate((String)"47865.7916666665110000 days since 1858-11-17 00:00:00 UTC");
        String isoDateTimeString = this.formatter.toDateTimeStringISO(d);
        String expectedValue = "1989-12-05T19:00:00Z";
        TestDate.assertEquals((String)("Calculated date string [" + isoDateTimeString + "] not as expected [" + expectedValue + "]."), (String)expectedValue, (String)isoDateTimeString);
    }

    public void testTime() {
        this.doTime2(1.0, "years since 1985", true);
        this.doTime2(1.0, "year since 1985", true);
    }

    public void testDoublePrecision() {
        double dval = 47865.79166666651;
        double eval = 47865.791666666664;
        System.out.println(" dval= " + dval);
        System.out.println(" eval= " + eval);
        System.out.println(" diff= " + (eval - dval));
        System.out.println(" rdiff= " + (eval - dval) / eval);
        System.out.println(" rdiff= " + (1.0 - dval / eval));
        double rdiff = eval - dval;
        System.out.println(" add= " + (rdiff + dval));
        rdiff = 1.0 - dval / eval;
        System.out.println(" add= " + (rdiff + eval));
    }

    public void testStandardDatePrecision2() throws Exception {
        DateUnit du = new DateUnit("days since 1858-11-17 00:00:00 UTC");
        System.out.println(" date= " + this.formatter.toDateTimeStringISO(du.makeDate(0.0)));
        System.out.println(" dateOrigin= " + this.formatter.toDateTimeStringISO(du.getDateOrigin()));
        Date isoDate = this.formatter.getISODate("1989-12-05T19:00:00Z");
        System.out.println(" dateWant= " + this.formatter.toDateTimeStringISO(isoDate));
        double val = du.makeValue(isoDate);
        System.out.println(" days since= " + val);
        Date roundTrip = du.makeDate(val);
        System.out.println(" roundTrip= " + this.formatter.toDateTimeStringISO(roundTrip));
        assert (roundTrip.equals(isoDate));
    }
}

