/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Date;
import junit.framework.TestCase;
import ucar.nc2.units.DateFromString;

public class TestDateFromString
extends TestCase {
    private String fileName = "xzy_tds_20051129_1235_junk.grib";
    private String dateAsISOString = "2005-11-29T12:35";
    private long dateAsLong = 1133267700000L;

    public TestDateFromString(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testGetDateUsingSimpleDateFormat() {
        String dateFormatString = "yyyyMMdd_HHmm";
        Date date = DateFromString.getDateUsingSimpleDateFormat((String)this.fileName, (String)dateFormatString);
        TestDateFromString.assertTrue((String)("Calculated date <" + date.toString() + " [" + date.getTime() + "]> not as expected <" + this.dateAsISOString + "[" + this.dateAsLong + "]>." + "\nUsing fileName <" + this.fileName + "> and dateFormatString <" + dateFormatString + ">"), (date.getTime() == this.dateAsLong ? 1 : 0) != 0);
    }

    public void testGetDateUsingCompleteDateFormat() {
        String dateFormatString = "'xzy_tds_'yyyyMMdd_HHmm'_junk.grib'";
        Date date = DateFromString.getDateUsingCompleteDateFormat((String)this.fileName, (String)dateFormatString);
        TestDateFromString.assertTrue((String)("Calculated date <" + date.toString() + " [" + date.getTime() + "]> not as expected <" + this.dateAsISOString + "[" + this.dateAsLong + "]>." + "\nUsing fileName <" + this.fileName + "> and dateFormatString <" + dateFormatString + ">"), (date.getTime() == this.dateAsLong ? 1 : 0) != 0);
    }

    public void testGetDateUsingRegExp() {
        String matchPattern = ".*([0-9]{4})([0-9]{2})([0-9]{2})_([0-9]{2})([0-9]{2}).*grib";
        String substitutionPattern = "$1-$2-$3T$4:$5";
        Date date = DateFromString.getDateUsingRegExp((String)this.fileName, (String)matchPattern, (String)substitutionPattern);
        TestDateFromString.assertTrue((String)("Calculated date <" + date.toString() + " [" + date.getTime() + "]> not as expected <" + this.dateAsISOString + "[" + this.dateAsLong + "]>." + "\nUsing fileName <" + this.fileName + ">, matchPattern <" + matchPattern + ">, and substitutionPattern <" + substitutionPattern + ">"), (date.getTime() == this.dateAsLong ? 1 : 0) != 0);
    }

    public void testGetDateUsingRegExpAndDateFormat() {
        String matchPattern = ".*([0-9]{4})([0-9]{2})([0-9]{2})_([0-9]{2})([0-9]{2}).*grib";
        String substitutionPattern = "$1$2$3_$4$5";
        String dateFormatString = "yyyyMMdd_HHmm";
        Date date = DateFromString.getDateUsingRegExpAndDateFormat((String)this.fileName, (String)matchPattern, (String)substitutionPattern, (String)dateFormatString);
        TestDateFromString.assertTrue((String)("Calculated date <" + date.toString() + " [" + date.getTime() + "]> not as expected <" + this.dateAsISOString + "[" + this.dateAsLong + "]>." + "\nUsing fileName <" + this.fileName + ">, matchPattern <" + matchPattern + ">, substitutionPattern <" + substitutionPattern + ">, and dateFormatString <" + dateFormatString + ">"), (date.getTime() == this.dateAsLong ? 1 : 0) != 0);
    }
}

