/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class TestDateRange
extends TestCase {
    public TestDateRange(String name) {
        super(name);
    }

    public void testStartPresentAndDuration() {
        DateRange drStartIsPresent;
        try {
            drStartIsPresent = new DateRange(new DateType("present", null, null), null, new TimeDuration("P7D"), null);
        }
        catch (ParseException e) {
            TestDateRange.fail((String)("Failed to parse \"present\" and/or \"P7D\": " + e.getMessage()));
            return;
        }
        this.checkValuesAfterDelay(drStartIsPresent);
    }

    public void testEndPresentAndDuration() {
        DateRange drEndIsPresent;
        try {
            drEndIsPresent = new DateRange(null, new DateType("present", null, null), new TimeDuration("P7D"), null);
        }
        catch (ParseException e) {
            TestDateRange.fail((String)("Failed to parse \"present\" and/or \"P7D\": " + e.getMessage()));
            return;
        }
        this.checkValuesAfterDelay(drEndIsPresent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValuesAfterDelay(DateRange dr) {
        long d = Calendar.getInstance().getTimeInMillis();
        Date startDate = dr.getStart().getDate();
        Date endDate = dr.getEnd().getDate();
        System.out.println("Current : " + d);
        System.out.println("Start   :  [" + startDate.getTime() + "].");
        System.out.println("End     :  [" + endDate.getTime() + "].");
        try {
            TestDateRange testDateRange = this;
            synchronized (testDateRange) {
                boolean cond = false;
                while (!cond) {
                    ((Object)((Object)this)).wait(10000L);
                    cond = true;
                }
            }
        }
        catch (InterruptedException e) {
            TestDateRange.fail((String)("Failed to wait: " + e.getMessage()));
            return;
        }
        long d2 = Calendar.getInstance().getTimeInMillis();
        Date startDate2 = dr.getStart().getDate();
        Date endDate2 = dr.getEnd().getDate();
        System.out.println("\nCurrent : " + d2);
        System.out.println("Start   : [" + startDate2.getTime() + "].");
        System.out.println("End     : [" + endDate2.getTime() + "].");
        TestDateRange.assertTrue((String)"Start dates are equal ", (!startDate.equals(startDate2) ? 1 : 0) != 0);
        TestDateRange.assertTrue((String)"End dates are equal [", (!endDate.equals(endDate2) ? 1 : 0) != 0);
    }
}

