/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import junit.framework.TestCase;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;

public class TestSimpleUnits
extends TestCase {
    public TestSimpleUnits(String name) {
        super(name);
    }

    private void tryConvert() throws Exception {
        SimpleUnit t1 = SimpleUnit.factory((String)"1 days");
        SimpleUnit t2 = SimpleUnit.factory((String)"1 hour");
        double v = t1.convertTo(1.0, t2);
        System.out.println(t1 + " convertTo " + t2 + " = " + v);
        assert (v == 24.0);
    }

    public void testUnits() throws Exception {
        SimpleUnit su = SimpleUnit.factory((String)"11 hPa");
        assert (!(su instanceof TimeUnit));
        assert (su.getValue() == 1100.0) : su;
        assert (su.getUnitString().equals("Pa")) : su;
        su = SimpleUnit.factory((String)"11 km");
        assert (!(su instanceof TimeUnit));
        assert (su.getValue() == 11000.0) : su;
        assert (su.getUnitString().equals("m")) : su;
        SimpleUnit tu = SimpleUnit.factory((String)"3 days");
        assert (tu instanceof TimeUnit) : tu.getClass().getName();
        assert (tu.getUnitString().equals("days"));
        assert (tu.getValue() == 3.0) : su;
        this.tryConvert();
    }

    public void testCompatible() {
        SimpleUnit su = SimpleUnit.factory((String)"11 hPa");
        assert (su.isCompatible("mbar"));
        assert (!su.isCompatible("m"));
        assert (!su.isCompatible("sec"));
        assert (!su.isCompatible("3 days since 1930-07-27 12:00:00-05:00"));
    }
}

