/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import timing.Average;
import timing.PerformanceChecker;
import timing.PerformanceHarness;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public class TimingUnits {
    private static final int RUNS = 10;
    private static final long TEST_TIME = 100L;

    public static void main(String[] args) throws Exception {
        TimingUnits.test(1);
        TimingUnits.test(1);
    }

    private static void test(int length) {
        PerformanceHarness harness = new PerformanceHarness();
        Average dateUnit = harness.calculatePerf(new PerformanceChecker(100L, new DateUnitTest("sec since 2006-01-01T12:23:00")), 10);
        Average udUnit = harness.calculatePerf(new PerformanceChecker(100L, new UdunitsTest("sec since 2006-01-01T12:23")), 10);
        Average dateForm = harness.calculatePerf(new PerformanceChecker(100L, new DateFormatterTest("2006-01-01T12:23")), 10);
        System.out.println(" date avg= " + dateUnit.mean() + " dev= " + dateUnit.stddev());
        System.out.println(" udUnit  avg= " + udUnit.mean() + " dev= " + udUnit.stddev());
        System.out.println(" udUnit/date  avg= " + udUnit.mean() / dateUnit.mean());
        System.out.println(" dateForm  avg= " + dateForm.mean() + " dev= " + dateForm.stddev());
        System.out.println(" dateForm/udUnit  avg= " + dateForm.mean() / udUnit.mean());
        System.out.println();
    }

    private static class DateFormatterTest
    implements Runnable {
        private static DateFormatter format = new DateFormatter();
        private final String s;

        public DateFormatterTest(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                format.getISODate(this.s);
            }
            catch (Exception e) {
                System.out.println(" error on parse" + e.getMessage());
            }
        }
    }

    private static class UdunitsTest
    implements Runnable {
        private static UnitFormat format = UnitFormatManager.instance();
        private final String s;

        public UdunitsTest(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                format.parse(this.s);
            }
            catch (Exception e) {
                System.out.println(" error on parse" + e.getMessage());
            }
        }
    }

    private static class DateUnitTest
    implements Runnable {
        private final String s;

        public DateUnitTest(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                new DateUnit(this.s);
            }
            catch (Exception e) {
                System.out.println(" error on parse" + e.getMessage());
            }
        }
    }
}

