/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.iosp.netcdf3.N3channelWriter;
import ucar.nc2.iosp.netcdf3.N3outputStreamWriter;
import ucar.nc2.util.IO;
import ucar.unidata.util.Format;

public class TimeSocket {
    int bufferSize = 8000;
    Average sendFake = new Average();
    Average copyFake = new Average();
    Average copyFile = new Average();
    Average copyZip = new Average();
    Average copyChannel = new Average();
    Average copyChannelFromRaf = new Average();
    Average streamOutputWriter = new Average();
    Average streamChannelWriter = new Average();
    private static String dir = "/data/ldm/pub/decoded/netcdf/grid/NCEP/";
    private FileTranverser ft;
    int count = 0;
    static int port = 8080;
    static InetAddress host;
    static String hostname;

    TimeSocket() {
    }

    double sendFake(int len) throws IOException {
        Socket s = new Socket(host, port);
        BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream(), this.bufferSize);
        byte[] b = new byte[this.bufferSize];
        for (int i = 0; i < len * 50; ++i) {
            ((OutputStream)out).write(b);
        }
        ((OutputStream)out).close();
        return len;
    }

    double copyFake(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        IO.copy2null((InputStream)in, (int)-1);
        ((InputStream)in).close();
        return f.length() / 1000000L;
    }

    double copyFile(File f) throws IOException {
        Socket s = new Socket(host, port);
        BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream(), this.bufferSize);
        IO.copyFileB((File)f, (OutputStream)out, (int)this.bufferSize);
        ((OutputStream)out).close();
        return f.length() / 1000000L;
    }

    double copyFileZipped(File f) throws IOException {
        Socket s = new Socket(host, port);
        BufferedOutputStream out = new BufferedOutputStream(new DeflaterOutputStream(s.getOutputStream()), this.bufferSize);
        IO.copyFileB((File)f, (OutputStream)out, (int)this.bufferSize);
        ((OutputStream)out).close();
        return f.length() / 1000000L;
    }

    double copyChannel(File f) throws IOException {
        long done;
        InetSocketAddress sadd = new InetSocketAddress(host, port);
        SocketChannel sc = SocketChannel.open(sadd);
        FileChannel fc = new FileInputStream(f).getChannel();
        long len = f.length();
        for (done = 0L; done < len; done += fc.transferTo(done, len - done, sc)) {
        }
        sc.close();
        return (double)done / 1000000.0;
    }

    double copyChannelFromRaf(File f) throws IOException {
        long done;
        InetSocketAddress sadd = new InetSocketAddress(host, port);
        SocketChannel sc = SocketChannel.open(sadd);
        FileChannel fc = new RandomAccessFile(f, "r").getChannel();
        long len = f.length();
        for (done = 0L; done < len; done += fc.transferTo(done, len - done, sc)) {
        }
        sc.close();
        return (double)done / 1000000.0;
    }

    double streamOutputWriter(File f) throws IOException, InvalidRangeException {
        Socket s = new Socket(host, port);
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(s.getOutputStream(), this.bufferSize));
        NetcdfFile ncfile = NetcdfFile.open((String)f.getPath());
        N3outputStreamWriter writer = new N3outputStreamWriter(ncfile);
        writer.writeHeader(stream, -1);
        writer.writeDataAll(stream);
        stream.close();
        stream.close();
        return (double)f.length() / 1000000.0;
    }

    double streamChannelWriter(File f) throws IOException, InvalidRangeException {
        InetSocketAddress sadd = new InetSocketAddress(host, port);
        SocketChannel sc = SocketChannel.open(sadd);
        NetcdfFile ncfile = NetcdfFile.open((String)f.getPath());
        N3channelWriter.writeToChannel((NetcdfFile)ncfile, (WritableByteChannel)sc);
        sc.close();
        return (double)f.length() / 1000000.0;
    }

    double copyChannelFromNetcdf(File f) throws IOException, InvalidRangeException {
        InetSocketAddress sadd = new InetSocketAddress(host, port);
        SocketChannel sc = SocketChannel.open(sadd);
        int done = 0;
        NetcdfFile ncfile = NetcdfFile.open((String)f.getPath());
        String want = "T,u,v,RH,Z,omega,absvor,T_fhg,u_fhg,v_fhg,RH_fhg";
        StringTokenizer stoke = new StringTokenizer(want, ",");
        while (stoke.hasMoreTokens()) {
            ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)stoke.nextToken());
            done = (int)((long)done + cer.v.readToByteChannel(cer.section, (WritableByteChannel)sc));
        }
        sc.close();
        return (double)done / 1000000.0;
    }

    private File getFile() {
        File result;
        if (null == this.ft) {
            this.ft = new FileTranverser(new File(dir));
        }
        if ((result = this.ft.next()) == null) {
            System.out.println("Done");
            System.exit(0);
        }
        if (!result.exists()) {
            return this.getFile();
        }
        System.out.println("Using file=" + result.getPath() + " size= " + result.length());
        return result;
    }

    public void run() throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        double len = this.sendFake(100);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        double rate = took / len;
        this.sendFake.add(rate);
        System.out.println("sendFake took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.copyFake(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.copyFake.add(rate);
        System.out.println("copyFake took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.copyFile(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.copyFile.add(rate);
        System.out.println("BufferedInputStream->BufferedOutputStream took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.copyFileZipped(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.copyZip.add(rate);
        System.out.println("copyZip took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.copyChannel(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.copyChannel.add(rate);
        System.out.println("FileChannel.transferTo(socketChannel) took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.streamOutputWriter(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.streamOutputWriter.add(rate);
        System.out.println("N3outputStreamWriter(socket.outputStream) took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        start = System.currentTimeMillis();
        len = this.streamChannelWriter(this.getFile());
        took = 0.001 * (double)(System.currentTimeMillis() - start);
        rate = took / len;
        this.streamChannelWriter.add(rate);
        System.out.println("N3channelWriter(socketChannel) took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " sec/Mb");
        System.out.println("Run " + this.count);
        System.out.println("  sendFake=           " + this.sendFake);
        System.out.println("  copyFake=           " + this.copyFake);
        System.out.println("  copyFile=           " + this.copyFile);
        System.out.println("  copyZip=            " + this.copyZip);
        System.out.println("  copyChannel=        " + this.copyChannel);
        System.out.println("  streamOutputWriter= " + this.streamOutputWriter);
        System.out.println("  streamChannelWriter=" + this.streamChannelWriter);
        ++this.count;
        System.out.println();
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, InterruptedException {
        int i;
        int skipFiles;
        if (args.length == 1 && args[0].equals("help")) {
            System.out.println("ucar.nc2.TimeSocket [skip]");
            System.out.println("ucar.nc2.TimeSocket <directory> <skip>");
            System.out.println("ucar.nc2.TimeSocket <directory> <skip> <wait secs>");
            System.exit(0);
        }
        TimeSocket test = new TimeSocket();
        host = InetAddress.getByName(hostname);
        System.out.println("host=" + host);
        if (args.length == 2 && args[1].equals("test")) {
            File f;
            dir = args[0];
            while (null != (f = test.getFile())) {
                System.out.println("  " + f.getPath());
            }
            System.exit(0);
        }
        int wait_secs = 10;
        if (args.length > 2) {
            dir = args[0];
            skipFiles = Integer.parseInt(args[1]);
            for (i = 0; i < skipFiles; ++i) {
                test.getFile();
            }
            wait_secs = Integer.parseInt(args[2]);
        } else if (args.length > 1) {
            dir = args[0];
            skipFiles = Integer.parseInt(args[1]);
            for (i = 0; i < skipFiles; ++i) {
                test.getFile();
            }
        } else if (args.length > 0) {
            skipFiles = Integer.parseInt(args[0]);
            for (i = 0; i < skipFiles; ++i) {
                test.getFile();
            }
        }
        while (true) {
            test.run();
            Thread.currentThread();
            Thread.sleep(1000 * wait_secs);
        }
    }

    static {
        hostname = "BERT.unidata.ucar.edu";
    }

    private class Average {
        int count = -3;
        private ArrayList values = new ArrayList();

        private Average() {
        }

        public void add(double value) {
            ++this.count;
            if (this.count < 1) {
                return;
            }
            if (!Double.isInfinite(value) && !Double.isNaN(value) && value > 0.0) {
                this.values.add(new Double(value));
            }
        }

        public double mean() {
            int elements = this.values.size();
            if (elements == 0) {
                return 0.0;
            }
            double sum = 0.0;
            for (int i = 0; i < this.values.size(); ++i) {
                Double valo = (Double)this.values.get(i);
                sum += valo.doubleValue();
            }
            return sum / (double)elements;
        }

        public double stddev() {
            double mean = this.mean();
            double stddevtotal = 0.0;
            for (int i = 0; i < this.values.size(); ++i) {
                Double valo = (Double)this.values.get(i);
                double dev = valo - mean;
                stddevtotal += dev * dev;
            }
            return Math.sqrt(stddevtotal / (double)this.values.size());
        }

        public String toString() {
            return "mean=" + this.mean() + " stdev=" + this.stddev();
        }
    }

    private class FileTranverser {
        private List<File> files;
        private int next = 0;
        private boolean useFiles = true;
        private FileTranverser child;

        FileTranverser(File dir) {
            File[] fila = dir.listFiles();
            this.files = Arrays.asList(fila);
            this.next = 0;
        }

        File next() {
            File result;
            if (this.child != null) {
                result = this.child.next();
                if (result != null) {
                    return result;
                }
                this.child = null;
            }
            if (this.useFiles) {
                result = this.nextFile();
                if (result != null) {
                    return result;
                }
                this.useFiles = false;
                this.next = 0;
            }
            while (this.next < this.files.size()) {
                File f;
                if (!(f = this.files.get(this.next++)).isDirectory()) continue;
                this.child = new FileTranverser(f);
                File result2 = this.child.next();
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }

        File nextFile() {
            while (this.next < this.files.size()) {
                File f;
                if (!(f = this.files.get(this.next++)).getName().endsWith(".nc")) continue;
                return f;
            }
            return null;
        }
    }
}

