/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil;

public class TestFileCacheConcurrent
extends TestCase {
    FileCache cache;
    FileFactory factory = new MyFileFactory();
    int PRINT_EVERY = 1000;
    int CLIENT_THREADS = 50;
    int WAIT_MAX = 25;
    int MAX_TASKS = 1000;
    int NSAME = 3;
    AtomicInteger done = new AtomicInteger();

    public TestFileCacheConcurrent(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.cache = new FileCache(50, 100, 30);
    }

    void loadFiles(File dir, String suffix, List<String> result) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory() && !f.getName().equals("exclude")) {
                this.loadFiles(f, suffix, result);
                continue;
            }
            if (!f.getPath().endsWith(suffix) || f.length() <= 0L) continue;
            String want = StringUtil.replace((String)f.getPath(), (char)'\\', (String)"/");
            result.add(want);
        }
    }

    public void testConcurrentAccess() throws InterruptedException {
        FileCache.debugCleanup = false;
        ArrayList<String> fileList = new ArrayList<String>(100);
        this.loadFiles(new File("C:/data/"), "nc", fileList);
        int nfiles = fileList.size();
        System.out.println(" loaded " + nfiles + " files");
        Random r = new Random();
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(this.MAX_TASKS);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.CLIENT_THREADS, this.CLIENT_THREADS, 100L, TimeUnit.SECONDS, q);
        int count = 0;
        block0: while (true) {
            if (q.remainingCapacity() > this.NSAME) {
                String location = (String)fileList.get(r.nextInt(nfiles));
                int i = 0;
                while (true) {
                    if (i >= this.NSAME) continue block0;
                    pool.submit(new CallAcquire(location, r.nextInt(this.WAIT_MAX)));
                    if (++count % this.PRINT_EVERY == 0) {
                        Formatter f = new Formatter();
                        this.cache.showStats(f);
                        System.out.printf(" submit %d queue= %d cache= %s%n", count, q.size(), f);
                    }
                    ++i;
                }
            }
            Thread.sleep(100L);
        }
    }

    class CallAcquire
    implements Runnable {
        String location;
        int wait;

        CallAcquire(String location, int wait) {
            this.location = location;
            this.wait = wait;
        }

        @Override
        public void run() {
            block6: {
                try {
                    FileCacheable fc = TestFileCacheConcurrent.this.cache.acquire(TestFileCacheConcurrent.this.factory, this.location, null);
                    NetcdfFile ncfile = (NetcdfFile)fc;
                    assert (!ncfile.isUnlocked());
                    assert (null != ncfile.getIosp());
                    Thread.sleep(this.wait);
                    ncfile.close();
                    int d = TestFileCacheConcurrent.this.done.incrementAndGet();
                    if (d % TestFileCacheConcurrent.this.PRINT_EVERY == 0) {
                        System.out.printf(" done %d%n", d);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    System.out.println(" fail=" + e.getMessage());
                    e.printStackTrace();
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
    }

    class MyFileFactory
    implements FileFactory {
        MyFileFactory() {
        }

        public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile((String)location, (int)buffer_size, (CancelTask)cancelTask, (Object)iospMessage);
        }
    }
}

