/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.memory;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import ucar.nc2.NetcdfFile;

public class MemoryCounterAgent {
    private static Instrumentation instrumentation;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        MemoryCounterAgent.instrumentation = instrumentation;
    }

    public static long sizeOf(Object obj) {
        if (instrumentation == null) {
            throw new IllegalStateException("Instrumentation environment not initialised.");
        }
        long result = MemoryCounterAgent.isSharedFlyweight(obj) ? 0L : instrumentation.getObjectSize(obj);
        return result;
    }

    private static boolean isSharedFlyweight(Object obj) {
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                return true;
            }
            if (obj instanceof String) {
                return obj == ((String)obj).intern();
            }
            if (obj instanceof Boolean) {
                return obj == Boolean.TRUE || obj == Boolean.FALSE;
            }
            if (obj instanceof Integer) {
                return obj == Integer.valueOf((Integer)obj);
            }
            if (obj instanceof Short) {
                return obj == Short.valueOf((Short)obj);
            }
            if (obj instanceof Byte) {
                return obj == Byte.valueOf((Byte)obj);
            }
            if (obj instanceof Long) {
                return obj == Long.valueOf((Long)obj);
            }
            if (obj instanceof Character) {
                return obj == Character.valueOf(((Character)obj).charValue());
            }
        }
        return false;
    }

    public static long deepSizeOf(Object obj) {
        IdentityHashMap visited = new IdentityHashMap();
        Stack<Object> stack = new Stack<Object>();
        stack.push(obj);
        long result = 0L;
        do {
            result += MemoryCounterAgent.internalSizeOf(stack.pop(), stack, visited);
        } while (!stack.isEmpty());
        return result;
    }

    private static boolean skipObject(Object obj, Map visited) {
        return obj == null || visited.containsKey(obj) || MemoryCounterAgent.isSharedFlyweight(obj);
    }

    private static long internalSizeOf(Object obj, Stack stack, Map visited) {
        if (MemoryCounterAgent.skipObject(obj, visited)) {
            return 0L;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            MemoryCounterAgent.addArrayElementsToStack(clazz, obj, stack);
        } else {
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        stack.add(field.get(obj));
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        visited.put(obj, null);
        return MemoryCounterAgent.sizeOf(obj);
    }

    private static void addArrayElementsToStack(Class clazz, Object obj, Stack stack) {
        if (!clazz.getComponentType().isPrimitive()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                stack.add(Array.get(obj, i));
            }
        }
    }

    public static long deepSizeOf2(String name, Object obj, Class skipClass, boolean show) {
        if (show) {
            System.out.printf("%s %s\n", obj.getClass().getName(), name);
        }
        IdentityHashMap visited = new IdentityHashMap();
        Stack<NamedObject> stack = new Stack<NamedObject>();
        stack.push(new NamedObject(name, obj));
        long result = 0L;
        do {
            result += MemoryCounterAgent.internalSizeOf2((NamedObject)stack.pop(), stack, visited, skipClass, show);
        } while (!stack.isEmpty());
        return result;
    }

    private static long internalSizeOf2(NamedObject nobj, Stack<NamedObject> stack, Map visited, Class skipClass, boolean show) {
        Object obj = nobj.obj;
        if (MemoryCounterAgent.skipObject(obj, visited)) {
            return 0L;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            MemoryCounterAgent.addArrayElementsToStack2(clazz, nobj, stack);
        } else {
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        Object val = field.get(obj);
                        if (skipClass != null && skipClass.isInstance(val) || val instanceof Class || val instanceof NetcdfFile) continue;
                        stack.add(new NamedObject(nobj.name + "-" + field.getName(), val));
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        visited.put(obj, null);
        long result = MemoryCounterAgent.sizeOf(obj);
        if (show) {
            System.out.printf("  %5d %s (%s)%n", result, nobj.name, obj.getClass().getName());
        }
        return result;
    }

    private static void addArrayElementsToStack2(Class clazz, NamedObject nobj, Stack<NamedObject> stack) {
        if (!clazz.getComponentType().isPrimitive()) {
            int length = Array.getLength(nobj.obj);
            for (int i = 0; i < length; ++i) {
                stack.add(new NamedObject(nobj.name, Array.get(nobj.obj, i)));
            }
        }
    }

    public static long deepSizeOf3(String name, Object obj, Class skipClass, boolean show) {
        if (show) {
            System.out.printf("%s %s\n", obj.getClass().getName(), name);
        }
        IdentityHashMap visited = new IdentityHashMap();
        long result = MemoryCounterAgent.deepSizeOf3(name, obj, visited, skipClass, show, 0);
        return result;
    }

    private static long deepSizeOf3(String name, Object obj, Map visited, Class skipClass, boolean show, int indent) {
        long result = MemoryCounterAgent.internalSizeOf3(name, obj, visited, skipClass, show, indent);
        if (show) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            System.out.printf("%6d %s (%s)\n", result, name, obj.getClass().getName());
        }
        return result;
    }

    private static long internalSizeOf3(String name, Object obj, Map visited, Class skipClass, boolean show, int indent) {
        Class<?> clazz;
        if (MemoryCounterAgent.skipObject(obj, visited)) {
            return 0L;
        }
        visited.put(obj, null);
        long result = MemoryCounterAgent.sizeOf(obj);
        if (clazz.isArray() && !clazz.getComponentType().isPrimitive()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object val = Array.get(obj, i);
                if (val == null) continue;
                result += MemoryCounterAgent.deepSizeOf3(name, val, visited, skipClass, show, indent + 2);
            }
        } else {
            for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        Object val = field.get(obj);
                        if (val == null || skipClass != null && skipClass.isInstance(val) || val instanceof Class || val instanceof NetcdfFile) continue;
                        result += MemoryCounterAgent.deepSizeOf3(name + "-" + field.getName(), val, visited, skipClass, show, indent + 2);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return result;
    }

    private static class NamedObject {
        String name;
        Object obj;

        NamedObject(String name, Object obj) {
            this.name = name;
            this.obj = obj;
        }
    }
}

