/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.util.HashMap;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Misc;

public class MetarField {
    static HashMap<String, MetarField> fields = new HashMap();
    boolean showFields = false;
    String name;
    boolean isText;
    double sum = 0.0;

    MetarField(String name) {
        this.name = name;
        fields.put(name, this);
        if (this.showFields) {
            System.out.println(name + " added");
        }
    }

    void sum(StructureData sdata, StructureMembers.Member m) {
        if (m.getDataType() == DataType.DOUBLE) {
            this.sum(sdata.getScalarDouble(m));
        } else if (m.getDataType() == DataType.FLOAT) {
            this.sum(sdata.getScalarFloat(m));
        } else if (m.getDataType() == DataType.INT) {
            this.sum(sdata.getScalarInt(m));
        }
    }

    void sum(String text) {
        if (this.isText) {
            return;
        }
        try {
            this.sum(Double.parseDouble(text));
        }
        catch (NumberFormatException e) {
            if (this.showFields) {
                System.out.println(this.name + " is text");
            }
            this.isText = true;
        }
    }

    void sum(double d) {
        if (!Misc.closeEnough((double)d, (double)-99999.0)) {
            this.sum += d;
        }
    }
}

