/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.xml.MetarField;
import ucar.unidata.util.Format;

public class TimeStaxReading {
    static boolean show = false;
    static boolean process = true;
    static boolean showFields = false;
    XMLStreamReader r;
    int nmetars = 0;
    long nelems = Long.MAX_VALUE;
    boolean readFields = false;
    int tab = 0;

    TimeStaxReading(XMLInputFactory myFactory, String filename) throws FileNotFoundException {
        long start = System.currentTimeMillis();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        try {
            this.r = myFactory.createXMLStreamReader(in);
            int eventType = this.r.next();
            if (eventType == 1) {
                this.readElement();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            String text = this.r.hasText() ? this.r.getText().trim() : "";
            System.out.println("BAD  text=(" + text + ")");
        }
        System.out.println("Read metar XML; # metars= " + this.nmetars);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        System.out.println(" that took = " + took + "sec; " + Format.d((double)((double)this.nmetars / took), (int)0) + " metars/sec");
        for (MetarField f : MetarField.fields.values()) {
            System.out.println(" " + f.name + " = " + f.sum);
        }
    }

    void readElement() throws XMLStreamException {
        int eventType;
        ++this.tab;
        this.indent();
        if (show) {
            System.out.print(this.r.getLocalName());
        }
        if (this.r.getLocalName().equals("metar")) {
            ++this.nmetars;
        }
        int natts = this.r.getAttributeCount();
        String fldName = null;
        for (int i = 0; i < natts; ++i) {
            String name = this.r.getAttributeLocalName(i);
            String val = this.r.getAttributeValue(i);
            if (show) {
                System.out.print(" " + name + "='" + val + "'");
            }
            if (!name.equals("name")) continue;
            fldName = val;
        }
        if (show) {
            System.out.println();
        }
        if (!this.readFields && this.r.getLocalName().equals("data")) {
            if (MetarField.fields.get(fldName) != null) {
                this.readFields = true;
            } else {
                new MetarField(fldName);
            }
        }
        while (this.r.hasNext() && (long)this.nmetars < this.nelems && 2 != (eventType = this.r.next())) {
            String text;
            if (1 == eventType) {
                this.readElement();
                continue;
            }
            if (4 == eventType) {
                String string = text = this.r.hasText() ? this.r.getText().trim() : "";
                if (!process || text.length() <= 0) continue;
                MetarField fld = MetarField.fields.get(fldName);
                if (null != fld) {
                    fld.sum(text);
                }
                this.indent();
                if (!show) continue;
                System.out.println("  text=(" + text + ")");
                continue;
            }
            text = this.r.hasText() ? this.r.getText().trim() : "";
            String name = this.r.hasName() ? this.r.getLocalName() : "";
            this.indent();
            if (show) {
                System.out.print(TimeStaxReading.eventName(eventType) + ": " + name);
            }
            if (text.length() > 0 && show) {
                System.out.print(" text=(" + text + ")");
            }
            if (!show) continue;
            System.out.println();
        }
        --this.tab;
    }

    void indent() {
        if (!show) {
            return;
        }
        for (int i = 0; i < this.tab; ++i) {
            System.out.print("  ");
        }
    }

    static String eventName(int type) {
        switch (type) {
            case 7: {
                return " startDoc";
            }
            case 1: {
                return "startElem";
            }
            case 8: {
                return "   endDoc";
            }
            case 2: {
                return "  endElem";
            }
            case 10: {
                return "attribute";
            }
            case 4: {
                return "    chars";
            }
        }
        return " " + type;
    }

    static void readFromNetcdf(String filename) throws IOException {
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure record = (Structure)ncfile.findVariable("record");
        List members = record.getVariables();
        for (Variable v : members) {
            if (v.getDataType() == DataType.CHAR) continue;
            new MetarField(v.getShortName());
        }
        StructureDataIterator siter = record.getStructureIterator();
        int count = 0;
        while (siter.hasNext()) {
            StructureData sdata = siter.next();
            List sm = sdata.getMembers();
            for (StructureMembers.Member m : sm) {
                MetarField f = MetarField.fields.get(m.getName());
                if (null == f) continue;
                f.sum(sdata, m);
            }
            ++count;
        }
        System.out.println("Read from NetCDF; # metars= " + count);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        System.out.println(" that took = " + took + " sec; " + Format.d((double)((double)count / took), (int)0) + " metars/sec");
        for (MetarField f : MetarField.fields.values()) {
            System.out.println(" " + f.name + " = " + f.sum);
        }
        ncfile.close();
    }

    public static void main(String[] args) throws XMLStreamException, IOException {
        XMLInputFactory myFactory = XMLInputFactory.newInstance();
        myFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        new TimeStaxReading(myFactory, "C:/TEMP/thredds.xml");
    }
}

