/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.util.Random;
import junit.framework.TestCase;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class TestProjectionTiming
extends TestCase {
    int REPEAT = 100;
    int NPTS = 1000;
    double TOLERENCE = 1.0E-6;
    boolean checkit = true;
    long sumNormal = 0L;
    long sumArray = 0L;

    public TestProjectionTiming(String name) {
        super(name);
    }

    void timeProjection(ProjectionImpl proj) {
        Random r = new Random(((Object)((Object)this)).hashCode());
        LatLonPointImpl startL = new LatLonPointImpl();
        double[][] from = new double[2][this.NPTS];
        for (int i = 0; i < this.NPTS; ++i) {
            from[0][i] = 180.0 * (r.nextDouble() - 0.5);
            from[1][i] = 360.0 * (r.nextDouble() - 0.5);
        }
        int n = this.REPEAT * this.NPTS;
        long t1 = System.currentTimeMillis();
        for (int k = 0; k < this.REPEAT; ++k) {
            for (int i = 0; i < this.NPTS; ++i) {
                ProjectionPointImpl p = proj.latLonToProj(from[0][i], from[1][i]);
                LatLonPoint endL = proj.projToLatLon((ProjectionPoint)p);
                if (!this.checkit) continue;
                assert (this.close(from[0][i], endL.getLatitude())) : "lat: " + from[0][i] + "!=" + endL.getLatitude();
                assert (this.close(from[1][i], endL.getLongitude())) : "lon: " + from[1][i] + "!=" + endL.getLongitude();
            }
        }
        long took = System.currentTimeMillis() - t1;
        this.sumNormal += took;
        System.out.println(n + " normal " + proj.getClassName() + " took " + took + " msecs ");
        long t2 = System.currentTimeMillis();
        for (int k = 0; k < this.REPEAT; ++k) {
            double[][] to = proj.latLonToProj(from);
            double[][] result2 = proj.projToLatLon(to);
            if (!this.checkit) continue;
            for (int i = 0; i < this.NPTS; ++i) {
                assert (this.close(from[0][i], result2[0][i])) : "lat: " + from[0][i] + "!=" + result2[0][i];
                assert (this.close(from[1][i], result2[1][i])) : "lon: " + from[1][i] + "!=" + result2[1][i];
            }
        }
        took = System.currentTimeMillis() - t2;
        this.sumArray += took;
        System.out.println(n + " array " + proj.getClassName() + " took " + took + " msecs ");
    }

    boolean close(double d1, double d2) {
        return Math.abs(d1 - d2) < this.TOLERENCE;
    }

    public void testEachProjection() {
        this.timeProjection((ProjectionImpl)new LambertConformal());
        this.timeProjection((ProjectionImpl)new LambertConformal());
        this.timeProjection((ProjectionImpl)new LambertConformal());
        this.timeProjection((ProjectionImpl)new LambertConformal());
        System.out.println(" normal  took " + this.sumNormal + " msecs ");
        System.out.println(" array  took " + this.sumArray + " msecs ");
    }
}

