/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.File;
import java.util.Date;
import ucar.nc2.TestAll;
import ucar.nc2.util.DiskCache;

public class TestDiskCacheUtils {
    private TestDiskCacheUtils() {
    }

    public static void setupDiskCacheInTmpDir(boolean alwaysInCache) {
        String cacheDir = TestAll.temporaryLocalDataDir + "cache/DiskCache/";
        if (!DiskCache.getRootDirectory().equals(cacheDir)) {
            DiskCache.setRootDirectory((String)cacheDir);
            DiskCache.makeRootDirectory();
        }
        DiskCache.setCachePolicy((boolean)alwaysInCache);
    }

    public static void emptyDiskCache(StringBuilder report) {
        DiskCache.cleanCache((Date)new Date(System.currentTimeMillis()), (StringBuilder)report);
    }

    public static void setupDiskCache2WithTmpRootDir() {
        String cacheDir = TestAll.temporaryLocalDataDir + "cache/DiskCache2/";
        File f = new File(cacheDir);
        if (!f.exists() && !f.mkdirs()) {
            throw new IllegalStateException("Could not create DiskCache2 temporary root directory [" + cacheDir + "].");
        }
        if (!f.isDirectory()) {
            throw new IllegalStateException("DiskCache2 temporary root directory [" + cacheDir + "] is not a directory.");
        }
        String prevValue = System.setProperty("nj22.cachePersistRoot", cacheDir);
    }
}

