/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class TestRegexp
extends TestCase {
    public TestRegexp(String name) {
        super(name);
    }

    public void test() {
        this.testOne("AG.*\\.nc", "AG2006001_2006003_ssta.nc", true);
        this.testOne("AG.*\\.nc", "AG2006001_2006003_ssta.hdf", false);
        this.testOne("AG.*\\.nc", "PS2006001_2006003_ssta.nc", false);
    }

    public void test2() {
        this.testOne(".*/AG.*\\.nc$", "C:/data/roy/caron/AG2006001_2006003_ssta.nc", true);
        this.testOne(".*/AG.*\\.nc$", "C:/data/roy/caron/AG2006001_2006003_ssta.hdf", false);
        this.testOne(".*/AG.*\\.nc$", "C:/data/roy/caron/PS2006001_2006003_ssta.nc", false);
    }

    public void test3() {
        this.testOne(".*JU[CM]E00 EGRR.*", "JUCE00 EGRR", true);
        this.testOne(".*JU[^CM]E00 EGRR.*", "JUCE00 EGRR", false);
    }

    public void test4() {
        this.testMatch(".*(J.....) (....) .*", "WMO JUBE99 EGRR 030000", true);
        this.testMatch(".*([IJ].....) (....) .*", "WMO IUBEs9 sssR 030000", true);
    }

    public void test5() {
        this.testMatch("(.*)\\(see Note.*", "Software identification (see Note 2)", true);
    }

    public void testSplit() {
        String[] split;
        for (String s : split = "what is  it".split("[ ]+")) {
            System.out.println("(" + s + ")");
        }
    }

    public void testEnd() {
        this.testMatch(".*\\.nc", "yomama.nc", true);
        this.testMatch(".*\\.nc", "yomamanc", false);
        this.testMatch(".*\\.nc", "yomama.nc.stuff", false);
        this.testMatch(".*\\.nc$", "yomama.nc.stuff", false);
    }

    private void testOne(String ps, String match, boolean expect) {
        Pattern pattern = Pattern.compile(ps);
        Matcher matcher = pattern.matcher(match);
        System.out.printf(" match %s against %s = %s %n", ps, match, matcher.matches());
        assert (matcher.matches() == expect);
    }

    private void testMatch(String ps, String match, boolean expect) {
        Pattern pattern = Pattern.compile(ps);
        Matcher matcher = pattern.matcher(match);
        System.out.printf(" match %s against %s = %s %n", ps, match, matcher.matches());
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            System.out.println(" " + i + " " + matcher.group(i));
        }
    }
}

