/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.cdm;

import java.io.IOException;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import uk.ac.rdg.resc.ncwms.cdm.RangesList;

class DataChunk {
    private static final Logger log = LoggerFactory.getLogger(DataChunk.class);
    private final VariableDS var;
    private final Array arr;
    private final boolean needsEnhance;

    private DataChunk(VariableDS var, Array arr, boolean needsEnhance) {
        this.var = var;
        this.arr = arr;
        this.needsEnhance = needsEnhance;
    }

    public static DataChunk readDataChunk(VariableDS var, RangesList ranges) throws IOException {
        Variable origVar = var.getOriginalVariable();
        Array arr = origVar == null ? DataChunk.readVariable((Variable)var, ranges) : DataChunk.readVariable(origVar, ranges);
        EnumSet enhanceMode = var.getEnhanceMode();
        boolean needsEnhance = enhanceMode.contains(NetcdfDataset.Enhance.ScaleMissingDefer) ? true : (enhanceMode.contains(NetcdfDataset.Enhance.ScaleMissing) ? origVar != null : false);
        return new DataChunk(var, arr, needsEnhance);
    }

    private static final Array readVariable(Variable var, RangesList ranges) throws IOException {
        try {
            log.debug("Reading from variable {} with ranges {}", (Object)var.getName(), (Object)ranges.toString());
            return var.read(ranges.getRanges());
        }
        catch (InvalidRangeException ire) {
            throw new IllegalArgumentException(ire);
        }
    }

    public Index getIndex() {
        return this.arr.getIndex();
    }

    public float readFloatValue(Index index) {
        double val = this.arr.getFloat(index);
        if (this.needsEnhance) {
            val = this.var.convertScaleOffsetMissing(val);
        }
        if (this.var.isMissing(val)) {
            return Float.NaN;
        }
        return (float)val;
    }
}

