/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.cdm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Index;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridDatatype;
import uk.ac.rdg.resc.ncwms.cdm.DataChunk;
import uk.ac.rdg.resc.ncwms.cdm.RangesList;
import uk.ac.rdg.resc.ncwms.coords.PixelMap;

public enum DataReadingStrategy {
    SCANLINE{

        @Override
        protected void doPopulatePixelArray(List<Float> picData, PixelMap pixelMap, VariableDS var, RangesList ranges) throws IOException {
            Iterator<PixelMap.PixelMapEntry> it = pixelMap.iterator();
            if (!it.hasNext()) {
                return;
            }
            PixelMap.PixelMapEntry pme = it.next();
            Scanline scanline = new Scanline(pme);
            while (it.hasNext()) {
                pme = it.next();
                int sourceJ = pme.getSourceGridJIndex();
                if (sourceJ == scanline.jIndex) {
                    scanline.addEntry(pme);
                    continue;
                }
                this.readScanline(picData, var, ranges, scanline);
                scanline = new Scanline(pme);
            }
            this.readScanline(picData, var, ranges, scanline);
        }

        private void readScanline(List<Float> picData, VariableDS var, RangesList ranges, Scanline scanline) throws IOException {
            ranges.setYRange(scanline.jIndex, scanline.jIndex);
            ranges.setXRange(scanline.iMin, scanline.iMax);
            DataChunk dataChunk = DataChunk.readDataChunk(var, ranges);
            Index index = dataChunk.getIndex();
            index.set(new int[index.getRank()]);
            for (PixelMap.PixelMapEntry pme : scanline.pixelMapEntries) {
                index.setDim(ranges.getXAxisIndex(), pme.getSourceGridIIndex() - scanline.iMin);
                float val = dataChunk.readFloatValue(index);
                if (Float.isNaN(val)) continue;
                for (int p : pme.getTargetGridPoints()) {
                    picData.set(p, Float.valueOf(val));
                }
            }
        }

        class Scanline {
            private final int jIndex;
            private int iMin = Integer.MAX_VALUE;
            private int iMax = -1;
            private final List<PixelMap.PixelMapEntry> pixelMapEntries = new ArrayList<PixelMap.PixelMapEntry>();

            public Scanline(PixelMap.PixelMapEntry pme) {
                this.jIndex = pme.getSourceGridJIndex();
                this.addEntry(pme);
            }

            public void addEntry(PixelMap.PixelMapEntry pme) {
                int srci = pme.getSourceGridIIndex();
                this.iMin = Math.min(srci, this.iMin);
                this.iMax = Math.max(srci, this.iMax);
                this.pixelMapEntries.add(pme);
            }
        }
    }
    ,
    BOUNDING_BOX{

        @Override
        protected void doPopulatePixelArray(List<Float> picData, PixelMap pixelMap, VariableDS var, RangesList ranges) throws IOException {
            int imin = pixelMap.getMinIIndex();
            int imax = pixelMap.getMaxIIndex();
            int jmin = pixelMap.getMinJIndex();
            int jmax = pixelMap.getMaxJIndex();
            ranges.setXRange(imin, imax);
            ranges.setYRange(jmin, jmax);
            DataChunk dataChunk = DataChunk.readDataChunk(var, ranges);
            Index index = dataChunk.getIndex();
            index.set(new int[index.getRank()]);
            for (PixelMap.PixelMapEntry pme : pixelMap) {
                index.setDim(ranges.getYAxisIndex(), pme.getSourceGridJIndex() - jmin);
                index.setDim(ranges.getXAxisIndex(), pme.getSourceGridIIndex() - imin);
                float val = dataChunk.readFloatValue(index);
                if (Float.isNaN(val)) continue;
                for (int targetGridPoint : pme.getTargetGridPoints()) {
                    picData.set(targetGridPoint, Float.valueOf(val));
                }
            }
        }
    }
    ,
    PIXEL_BY_PIXEL{

        @Override
        protected void doPopulatePixelArray(List<Float> picData, PixelMap pixelMap, VariableDS var, RangesList ranges) throws IOException {
            for (PixelMap.PixelMapEntry pme : pixelMap) {
                ranges.setYRange(pme.getSourceGridJIndex(), pme.getSourceGridJIndex());
                ranges.setXRange(pme.getSourceGridIIndex(), pme.getSourceGridIIndex());
                DataChunk dataChunk = DataChunk.readDataChunk(var, ranges);
                Index index = dataChunk.getIndex();
                index.set(new int[index.getRank()]);
                float val = dataChunk.readFloatValue(index);
                if (Float.isNaN(val)) continue;
                for (int targetGridPoint : pme.getTargetGridPoints()) {
                    picData.set(targetGridPoint, Float.valueOf(val));
                }
            }
        }
    };

    private static final Logger logger;

    private static ArrayList<Float> nullArrayList(int n) {
        ArrayList<Float> list = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            list.add(null);
        }
        return list;
    }

    public final void populatePixelArray(List<Float> picData, int tIndex, int zIndex, PixelMap pixelMap, GridDatatype grid) throws IOException {
        RangesList rangesList = new RangesList(grid);
        rangesList.setZRange(zIndex, zIndex);
        rangesList.setTRange(tIndex, tIndex);
        this.doPopulatePixelArray(picData, pixelMap, grid.getVariable(), rangesList);
    }

    abstract void doPopulatePixelArray(List<Float> var1, PixelMap var2, VariableDS var3, RangesList var4) throws IOException;

    static {
        logger = LoggerFactory.getLogger(DataReadingStrategy.class);
    }
}

