/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.coords.HorizontalGrid;
import uk.ac.rdg.resc.ncwms.exceptions.LayerNotDefinedException;
import uk.ac.rdg.resc.ncwms.exceptions.MetadataException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.usagelog.UsageLogEntry;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.util.Ranges;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Layer;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public abstract class AbstractMetadataController {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetadataController.class);
    private final AbstractWmsController.LayerFactory layerFactory;

    protected AbstractMetadataController(AbstractWmsController.LayerFactory layerFactory) {
        this.layerFactory = layerFactory;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response, UsageLogEntry usageLogEntry) throws MetadataException {
        try {
            String item = request.getParameter("item");
            usageLogEntry.setWmsOperation("GetMetadata:" + item);
            if (item == null) {
                throw new Exception("Must provide an ITEM parameter");
            }
            if (item.equals("menu")) {
                return this.showMenu(request, usageLogEntry);
            }
            if (item.equals("layerDetails")) {
                return this.showLayerDetails(request, usageLogEntry);
            }
            if (item.equals("timesteps")) {
                return this.showTimesteps(request);
            }
            if (item.equals("minmax")) {
                return this.showMinMax(request, usageLogEntry);
            }
            if (item.equals("animationTimesteps")) {
                return this.showAnimationTimesteps(request);
            }
            throw new Exception("Invalid value for ITEM parameter");
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    protected abstract ModelAndView showMenu(HttpServletRequest var1, UsageLogEntry var2) throws Exception;

    private ModelAndView showLayerDetails(HttpServletRequest request, UsageLogEntry usageLogEntry) throws Exception {
        Layer layer = this.getLayer(request);
        usageLogEntry.setLayer(layer);
        DateTime targetDateTime = new DateTime();
        String targetDateIso = request.getParameter("time");
        if (targetDateIso != null && !targetDateIso.trim().equals("")) {
            targetDateTime = WmsUtils.iso8601ToDateTime(targetDateIso, layer.getChronology());
        }
        LinkedHashMap datesWithData = new LinkedHashMap();
        List<DateTime> timeValues = layer.getTimeValues();
        DateTime nearestDateTime = timeValues.isEmpty() ? new DateTime(0L) : timeValues.get(0);
        for (DateTime dateTime : layer.getTimeValues()) {
            int day;
            int month;
            ArrayList<Integer> days;
            int year;
            LinkedHashMap months;
            dateTime = dateTime.withZone(DateTimeZone.UTC);
            long d1 = new Duration((ReadableInstant)dateTime, (ReadableInstant)targetDateTime).getMillis();
            long d2 = new Duration((ReadableInstant)nearestDateTime, (ReadableInstant)targetDateTime).getMillis();
            if (Math.abs(d1) < Math.abs(d2)) {
                nearestDateTime = dateTime;
            }
            if ((months = (LinkedHashMap)datesWithData.get(year = dateTime.getYear())) == null) {
                months = new LinkedHashMap();
                datesWithData.put(year, months);
            }
            if ((days = (ArrayList<Integer>)months.get(month = dateTime.getMonthOfYear() - 1)) == null) {
                days = new ArrayList<Integer>();
                months.put(month, days);
            }
            if (days.contains(day = dateTime.getDayOfMonth())) continue;
            days.add(day);
        }
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("layer", layer);
        models.put("datesWithData", datesWithData);
        models.put("nearestTimeIso", WmsUtils.dateTimeToISO8601(nearestDateTime));
        models.put("paletteNames", ColorPalette.getAvailablePaletteNames());
        return new ModelAndView("showLayerDetails", models);
    }

    private Layer getLayer(HttpServletRequest request) throws LayerNotDefinedException {
        String layerName = request.getParameter("layerName");
        if (layerName == null) {
            throw new LayerNotDefinedException("null");
        }
        return this.layerFactory.getLayer(layerName);
    }

    private ModelAndView showTimesteps(HttpServletRequest request) throws Exception {
        Layer layer = this.getLayer(request);
        if (layer.getTimeValues().isEmpty()) {
            return null;
        }
        String dayStr = request.getParameter("day");
        if (dayStr == null) {
            throw new Exception("Must provide a value for the day parameter");
        }
        DateTime date = WmsUtils.iso8601ToDateTime(dayStr, layer.getChronology());
        ArrayList<DateTime> timesteps = new ArrayList<DateTime>();
        for (DateTime tVal : layer.getTimeValues()) {
            if (!AbstractMetadataController.onSameDay(tVal, date)) continue;
            timesteps.add(tVal);
        }
        log.debug("Found {} timesteps on {}", (Object)timesteps.size(), (Object)dayStr);
        return new ModelAndView("showTimesteps", "timesteps", timesteps);
    }

    private static boolean onSameDay(DateTime dt1, DateTime dt2) {
        dt1 = dt1.withZone(DateTimeZone.UTC);
        dt2 = dt2.withZone(DateTimeZone.UTC);
        boolean onSameDay = dt1.getYear() == dt2.getYear() && dt1.getMonthOfYear() == dt2.getMonthOfYear() && dt1.getDayOfMonth() == dt2.getDayOfMonth();
        log.debug("onSameDay({}, {}) = {}", new Object[]{dt1, dt2, onSameDay});
        return onSameDay;
    }

    private ModelAndView showMinMax(HttpServletRequest request, UsageLogEntry usageLogEntry) throws Exception {
        List<Float> magnitudes;
        RequestParams params = new RequestParams(request.getParameterMap());
        GetMapDataRequest dr = new GetMapDataRequest(params, "1.3.0");
        Layer layer = this.layerFactory.getLayer(dr.getLayers()[0]);
        usageLogEntry.setLayer(layer);
        HorizontalGrid grid = new HorizontalGrid(dr.getCrsCode(), dr.getWidth(), dr.getHeight(), dr.getBbox());
        double zValue = AbstractWmsController.getElevationValue(dr.getElevationString(), layer);
        DateTime tValue = AbstractWmsController.getTimeValues(dr.getTimeString(), layer).get(0);
        if (layer instanceof ScalarLayer) {
            magnitudes = ((ScalarLayer)layer).readPointList(tValue, zValue, grid);
        } else if (layer instanceof VectorLayer) {
            VectorLayer vecLayer = (VectorLayer)layer;
            List<Float> east = vecLayer.getEastwardComponent().readPointList(tValue, zValue, grid);
            List<Float> north = vecLayer.getNorthwardComponent().readPointList(tValue, zValue, grid);
            magnitudes = WmsUtils.getMagnitudes(east, north);
        } else {
            throw new IllegalStateException("Invalid Layer type");
        }
        Range<Float> valueRange = Ranges.findMinMax(magnitudes);
        return new ModelAndView("showMinMax", "valueRange", valueRange);
    }

    private ModelAndView showAnimationTimesteps(HttpServletRequest request) throws Exception {
        Layer layer = this.getLayer(request);
        String startStr = request.getParameter("start");
        String endStr = request.getParameter("end");
        if (startStr == null || endStr == null) {
            throw new Exception("Must provide values for start and end");
        }
        int startIndex = AbstractWmsController.findTIndex(startStr, layer);
        int endIndex = AbstractWmsController.findTIndex(endStr, layer);
        List<DateTime> tValues = layer.getTimeValues();
        LinkedHashMap<String, String> timeStrings = new LinkedHashMap<String, String>();
        timeStrings.put("Full (" + (endIndex - startIndex + 1) + " frames)", startStr + "/" + endStr);
        AbstractMetadataController.addTimeString("Daily", timeStrings, tValues, startIndex, endIndex, new Period().withDays(1));
        AbstractMetadataController.addTimeString("Weekly", timeStrings, tValues, startIndex, endIndex, new Period().withWeeks(1));
        AbstractMetadataController.addTimeString("Monthly", timeStrings, tValues, startIndex, endIndex, new Period().withMonths(1));
        AbstractMetadataController.addTimeString("Bi-monthly", timeStrings, tValues, startIndex, endIndex, new Period().withMonths(2));
        AbstractMetadataController.addTimeString("Twice-yearly", timeStrings, tValues, startIndex, endIndex, new Period().withMonths(6));
        AbstractMetadataController.addTimeString("Yearly", timeStrings, tValues, startIndex, endIndex, new Period().withYears(1));
        return new ModelAndView("showAnimationTimesteps", "timeStrings", timeStrings);
    }

    private static void addTimeString(String label, Map<String, String> timeStrings, List<DateTime> tValues, int startIndex, int endIndex, Period resolution) {
        List<DateTime> timesteps = AbstractMetadataController.getAnimationTimesteps(tValues, startIndex, endIndex, resolution);
        if (timesteps.size() > 1) {
            String timeString = AbstractMetadataController.getTimeString(timesteps);
            timeStrings.put(label + " (" + timesteps.size() + " frames)", timeString);
        }
    }

    private static List<DateTime> getAnimationTimesteps(List<DateTime> tValues, int startIndex, int endIndex, Period resolution) {
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        times.add(tValues.get(startIndex));
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            DateTime lastdt = (DateTime)times.get(times.size() - 1);
            DateTime thisdt = tValues.get(i);
            if (thisdt.isBefore((ReadableInstant)lastdt.plus((ReadablePeriod)resolution))) continue;
            times.add(thisdt);
        }
        return times;
    }

    private static String getTimeString(List<DateTime> timesteps) {
        if (timesteps.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(WmsUtils.dateTimeToISO8601(timesteps.get(0)));
        for (int i = 1; i < timesteps.size(); ++i) {
            builder.append("," + WmsUtils.dateTimeToISO8601(timesteps.get(i)));
        }
        return builder.toString();
    }
}

