/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.awt.Color;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.util.Ranges;

public class GetMapStyleRequest {
    private String[] styles;
    private String imageFormat;
    private boolean transparent;
    private Color backgroundColour;
    private int opacity;
    private int numColourBands;
    private Boolean logarithmic;
    private Range<Float> colorScaleRange;

    public GetMapStyleRequest(RequestParams params) throws WmsException {
        String stylesStr = params.getMandatoryString("styles");
        this.styles = stylesStr.trim().equals("") ? new String[0] : stylesStr.split(",");
        this.imageFormat = params.getMandatoryString("format").replaceAll(" ", "+");
        String trans = params.getString("transparent", "false").toLowerCase();
        if (trans.equals("false")) {
            this.transparent = false;
        } else if (trans.equals("true")) {
            this.transparent = true;
        } else {
            throw new WmsException("The value of TRANSPARENT must be \"TRUE\" or \"FALSE\"");
        }
        try {
            String bgc = params.getString("bgcolor", "0xFFFFFF");
            if (bgc.length() != 8 || !bgc.startsWith("0x")) {
                throw new Exception();
            }
            this.backgroundColour = new Color(Integer.parseInt(bgc.substring(2), 16));
        }
        catch (Exception e) {
            throw new WmsException("Invalid format for BGCOLOR");
        }
        this.opacity = params.getPositiveInt("opacity", 100);
        if (this.opacity > 100) {
            this.opacity = 100;
        }
        this.colorScaleRange = GetMapStyleRequest.getColorScaleRange(params);
        this.numColourBands = GetMapStyleRequest.getNumColourBands(params);
        this.logarithmic = GetMapStyleRequest.isLogScale(params);
    }

    static Range<Float> getColorScaleRange(RequestParams params) throws WmsException {
        String csr = params.getString("colorscalerange");
        if (csr == null || csr.equalsIgnoreCase("default")) {
            return null;
        }
        if (csr.equalsIgnoreCase("auto")) {
            return Ranges.emptyRange();
        }
        try {
            float scaleMax;
            String[] scaleEls = csr.split(",");
            if (scaleEls.length != 2) {
                throw new Exception();
            }
            float scaleMin = Float.parseFloat(scaleEls[0]);
            if (Float.compare(scaleMin, scaleMax = Float.parseFloat(scaleEls[1])) > 0) {
                throw new Exception();
            }
            return Ranges.newRange(Float.valueOf(scaleMin), Float.valueOf(scaleMax));
        }
        catch (Exception e) {
            throw new WmsException("Invalid format for COLORSCALERANGE");
        }
    }

    static int getNumColourBands(RequestParams params) throws WmsException {
        int numColourBands = params.getPositiveInt("numcolorbands", 254);
        if (numColourBands > 254) {
            numColourBands = 254;
        }
        return numColourBands;
    }

    static Boolean isLogScale(RequestParams params) throws WmsException {
        String logScaleStr = params.getString("logscale");
        if (logScaleStr == null) {
            return null;
        }
        if (logScaleStr.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (logScaleStr.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new WmsException("The value of LOGSCALE must be TRUE or FALSE (or can be omitted");
    }

    public String[] getStyles() {
        return this.styles;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public Boolean isScaleLogarithmic() {
        return this.logarithmic;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public Color getBackgroundColour() {
        return this.backgroundColour;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public Range<Float> getColorScaleRange() {
        return this.colorScaleRange;
    }

    public int getNumColourBands() {
        return this.numColourBands;
    }
}

