/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPositionImpl;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;
import uk.ac.rdg.resc.ncwms.coords.LonLatPositionImpl;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidCrsException;

public final class CrsHelper {
    public static final String PLATE_CARREE_CRS_CODE = "CRS:84";
    public static final Set<String> SUPPORTED_CRS_CODES = Collections.unmodifiableSet(CRS.getSupportedCodes((String)"urn:ogc:def"));
    public static final CrsHelper CRS_84;
    private static final Map<CoordinateReferenceSystem, CrsHelper> CACHE;
    private CoordinateReferenceSystem crs;
    private MathTransform crsToLonLat;
    private MathTransform lonLatToCrs;
    private boolean isLatLon;

    private CrsHelper() {
    }

    public static CrsHelper fromCrsCode(String crsCode) throws InvalidCrsException {
        try {
            return CrsHelper.fromCrs(CRS.decode((String)crsCode, (boolean)true));
        }
        catch (Exception e) {
            throw new InvalidCrsException(crsCode);
        }
    }

    public static CrsHelper fromCrs(CoordinateReferenceSystem crs) {
        if (crs.getCoordinateSystem().getDimension() != 2) {
            throw new IllegalArgumentException("CRS must be two-dimensional");
        }
        CrsHelper crsHelper = CACHE.get(crs);
        if (crsHelper != null) {
            return crsHelper;
        }
        crsHelper = new CrsHelper();
        try {
            crsHelper.crs = crs;
            crsHelper.crsToLonLat = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
            crsHelper.lonLatToCrs = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs, (boolean)true);
            crsHelper.isLatLon = crsHelper.crsToLonLat.isIdentity();
            CACHE.put(crs, crsHelper);
            return crsHelper;
        }
        catch (FactoryException fe) {
            throw new RuntimeException(fe);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public boolean isPointValidForCrs(HorizontalPosition point) {
        return this.isPointValidForCrs(point.getX(), point.getY());
    }

    public boolean isPointValidForCrs(double x, double y) {
        CoordinateSystemAxis xAxis = this.crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis yAxis = this.crs.getCoordinateSystem().getAxis(1);
        return x >= xAxis.getMinimumValue() && x <= xAxis.getMaximumValue() && y >= yAxis.getMinimumValue() && y <= yAxis.getMaximumValue();
    }

    public LonLatPosition crsToLonLat(double x, double y) throws TransformException {
        if (this.isLatLon) {
            return new LonLatPositionImpl(x, y);
        }
        double[] point = new double[]{x, y};
        this.crsToLonLat.transform(point, 0, point, 0, 1);
        return new LonLatPositionImpl(point[0], point[1]);
    }

    public LonLatPosition crsToLonLat(HorizontalPosition point) throws TransformException {
        return this.crsToLonLat(point.getX(), point.getY());
    }

    public HorizontalPosition lonLatToCrs(LonLatPosition lonLatPoint) throws TransformException {
        return this.lonLatToCrs(lonLatPoint.getLongitude(), lonLatPoint.getLatitude());
    }

    public HorizontalPosition lonLatToCrs(double longitude, double latitude) throws TransformException {
        if (this.isLatLon) {
            return new LonLatPositionImpl(longitude, latitude);
        }
        double[] point = new double[]{longitude, latitude};
        this.lonLatToCrs.transform(point, 0, point, 0, 1);
        return new HorizontalPositionImpl(point[0], point[1]);
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    static {
        CACHE = new HashMap<CoordinateReferenceSystem, CrsHelper>();
        try {
            CRS_84 = CrsHelper.fromCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            CACHE.put((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, CRS_84);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

