/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.Arrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPositionImpl
implements DirectPosition {
    private final CoordinateReferenceSystem crs;
    private final double[] coords;

    public DirectPositionImpl(CoordinateReferenceSystem crs, double[] coords) {
        if (coords == null) {
            throw new NullPointerException();
        }
        if (coords.length == 0) {
            throw new IllegalArgumentException("Zero-length coordinates array");
        }
        DirectPositionImpl.checkCrs(crs, coords.length);
        this.crs = crs;
        this.coords = (double[])coords.clone();
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs, double coord1, double ... otherCoords) {
        int coordsLength = 1;
        if (otherCoords != null) {
            coordsLength += otherCoords.length;
        }
        this.coords = new double[coordsLength];
        this.coords[0] = coord1;
        if (otherCoords != null) {
            for (int i = 0; i < otherCoords.length; ++i) {
                this.coords[i + 1] = otherCoords[i];
            }
        }
        DirectPositionImpl.checkCrs(crs, this.coords.length);
        this.crs = crs;
    }

    private static void checkCrs(CoordinateReferenceSystem crs, int coordsLength) {
        if (crs != null && crs.getCoordinateSystem().getDimension() != coordsLength) {
            String msg = String.format("Dimensionality of CRS (%d) must match length of coordinate array (%d)", crs.getCoordinateSystem().getDimension(), coordsLength);
            throw new IllegalArgumentException(msg);
        }
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public final int getDimension() {
        return this.coords.length;
    }

    public final double[] getCoordinate() {
        return (double[])this.coords.clone();
    }

    public final double getOrdinate(int index) {
        if (index < 0 || index >= this.coords.length) {
            String msg = String.format("Attempt to access element at index %d in array of length %d", index, this.coords.length);
            throw new IndexOutOfBoundsException(msg);
        }
        return this.coords[index];
    }

    public final void setOrdinate(int index, double coordValue) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public String toString() {
        String s = String.format("Coords: %s ", Arrays.toString(this.coords));
        s = s + (this.crs == null ? "(null CRS)" : String.format("(CRS: %s)", this.crs.toString()));
        return s;
    }

    public final int hashCode() {
        int result = Arrays.hashCode(this.coords);
        if (this.crs != null) {
            result += this.crs.hashCode();
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DirectPosition)) {
            return false;
        }
        DirectPosition other = (DirectPosition)obj;
        if (!Arrays.equals(this.coords, other.getCoordinate())) {
            return false;
        }
        CoordinateReferenceSystem otherCrs = other.getCoordinateReferenceSystem();
        return this.crs == null ? otherCrs == null : this.crs.equals(otherCrs);
    }
}

