/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import org.opengis.metadata.extent.GeographicBoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.rdg.resc.ncwms.coords.CrsHelper;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPositionImpl;
import uk.ac.rdg.resc.ncwms.coords.PointList;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidCrsException;

public class HorizontalGrid
extends PointList {
    private static final Logger logger = LoggerFactory.getLogger(HorizontalGrid.class);
    private int width;
    private int height;
    private double[] bbox;
    private String crsCode;
    private CrsHelper crsHelper;
    private double[] xAxisValues;
    private double[] yAxisValues;

    public HorizontalGrid(String crsCode, int width, int height, double[] bbox) throws InvalidCrsException {
        this.crsHelper = CrsHelper.fromCrsCode(crsCode);
        this.crsCode = crsCode;
        this.width = width;
        this.height = height;
        this.bbox = bbox;
        this.initAxisValues();
        logger.debug("Created HorizontalGrid object for CRS {}", (Object)crsCode);
    }

    public HorizontalGrid(int width, int height, GeographicBoundingBox bbox) {
        this.crsHelper = CrsHelper.CRS_84;
        this.crsCode = "CRS:84";
        this.width = width;
        this.height = height;
        this.bbox = new double[]{bbox.getWestBoundLongitude(), bbox.getSouthBoundLatitude(), bbox.getEastBoundLongitude(), bbox.getNorthBoundLatitude()};
        this.initAxisValues();
    }

    private void initAxisValues() {
        double dx = (this.bbox[2] - this.bbox[0]) / (double)this.width;
        this.xAxisValues = new double[this.width];
        for (int i = 0; i < this.xAxisValues.length; ++i) {
            this.xAxisValues[i] = this.bbox[0] + ((double)i + 0.5) * dx;
        }
        double dy = (this.bbox[3] - this.bbox[1]) / (double)this.height;
        this.yAxisValues = new double[this.height];
        for (int i = 0; i < this.yAxisValues.length; ++i) {
            this.yAxisValues[i] = this.bbox[1] + ((double)(this.height - i) - 0.5) * dy;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double[] getBbox() {
        return this.bbox;
    }

    public double[] getXAxisValues() {
        return this.xAxisValues;
    }

    public double[] getYAxisValues() {
        return this.yAxisValues;
    }

    @Override
    public int size() {
        return this.width * this.height;
    }

    public boolean isLatLon() {
        return this.crsHelper.isLatLon();
    }

    @Override
    public CrsHelper getCrsHelper() {
        return this.crsHelper;
    }

    public String getCrsCode() {
        return this.crsCode;
    }

    @Override
    public HorizontalPosition getPoint(int index) {
        int yi = index / this.xAxisValues.length;
        int xi = index % this.xAxisValues.length;
        return new HorizontalPositionImpl(this.xAxisValues[xi], this.yAxisValues[yi]);
    }
}

