/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.AxisType;
import uk.ac.rdg.resc.ncwms.coords.Longitude;
import uk.ac.rdg.resc.ncwms.coords.OneDCoordAxis;

class Irregular1DCoordAxis
extends OneDCoordAxis {
    private static final Logger logger = LoggerFactory.getLogger(Irregular1DCoordAxis.class);
    private List<AxisValue> axisVals;

    public Irregular1DCoordAxis(double[] coordValues, AxisType axisType) {
        super(axisType, coordValues.length);
        this.axisVals = new ArrayList<AxisValue>(coordValues.length);
        for (int i = 0; i < coordValues.length; ++i) {
            if (Double.isNaN(coordValues[i])) continue;
            this.axisVals.add(new AxisValue(coordValues[i], i));
        }
        Collections.sort(this.axisVals);
        if (this.isLongitude()) {
            logger.debug("Checking for longitude axis wrapping...");
            double lastVal = this.axisVals.get(this.axisVals.size() - 1).value;
            double dx = lastVal - this.axisVals.get(this.axisVals.size() - 2).value;
            double nextVal = lastVal + dx;
            logger.debug("lastVal = {}, nextVal = {}", (Object)lastVal, (Object)nextVal);
            AxisValue firstVal = this.axisVals.get(0);
            Longitude firstValLon = new Longitude(firstVal.value);
            Longitude lastValLon = new Longitude(lastVal);
            Longitude nextValLon = new Longitude(nextVal);
            if (firstValLon.isBetween(lastVal, nextVal) || lastValLon.getClockwiseDistanceTo(nextVal) > nextValLon.getClockwiseDistanceTo(firstVal.value)) {
                logger.debug("Axis wraps, creating new point with lon = {}", (Object)(firstVal.value + 360.0));
                this.axisVals.add(new AxisValue(firstVal.value + 360.0, firstVal.index));
            }
        }
        logger.debug("Created irregular {} axis", (Object)this.getAxisType());
    }

    @Override
    public int getIndex(double coordValue) {
        logger.debug("Finding index for {} {} ...", (Object)this.getAxisType(), (Object)coordValue);
        int index = this.findNearest(coordValue);
        if (index < 0 && this.isLongitude() && coordValue < 0.0) {
            index = this.findNearest(coordValue + 360.0);
        }
        logger.debug("   ...index= {}", (Object)index);
        return index;
    }

    private int findNearest(double target) {
        if (target < this.axisVals.get(0).value || target > this.axisVals.get(this.axisVals.size() - 1).value) {
            return -1;
        }
        int low = 0;
        int high = this.axisVals.size() - 1;
        while (high > low + 1) {
            int mid = (low + high) / 2;
            AxisValue midVal = this.axisVals.get(mid);
            if (midVal.value == target) {
                return midVal.index;
            }
            if (midVal.value < target) {
                low = mid;
                continue;
            }
            high = mid;
        }
        AxisValue lowVal = this.axisVals.get(low);
        AxisValue highVal = this.axisVals.get(high);
        return Math.abs(target - lowVal.value) < Math.abs(target - highVal.value) ? lowVal.index : highVal.index;
    }

    @Override
    public double getCoordValue(int index) {
        return this.axisVals.get(index).value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Irregular1DCoordAxis)) {
            return false;
        }
        Irregular1DCoordAxis otherAxis = (Irregular1DCoordAxis)obj;
        if (this.axisVals.size() != otherAxis.axisVals.size()) {
            return false;
        }
        if (this.getAxisType() != otherAxis.getAxisType()) {
            return false;
        }
        for (int i = 0; i < this.axisVals.size(); ++i) {
            if (this.axisVals.get(i).equals(otherAxis.axisVals.get(i))) continue;
            return false;
        }
        return true;
    }

    private static final class AxisValue
    implements Comparable<AxisValue> {
        private double value;
        private int index;

        public AxisValue(double value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(AxisValue otherVal) {
            return Double.compare(this.value, otherVal.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AxisValue)) {
                return false;
            }
            AxisValue otherAxisVal = (AxisValue)obj;
            return this.value == otherAxisVal.value && this.index == otherAxisVal.index;
        }
    }
}

