/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dt.GridCoordSystem;
import uk.ac.rdg.resc.ncwms.coords.CurvilinearGrid;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;
import uk.ac.rdg.resc.ncwms.coords.LookUpTable;

final class TwoDCoordSys
extends HorizontalCoordSys {
    private static final Logger logger = LoggerFactory.getLogger(TwoDCoordSys.class);
    private static final Map<CurvilinearGrid, TwoDCoordSys> CACHE = new HashMap<CurvilinearGrid, TwoDCoordSys>();
    private final CurvilinearGrid curvGrid;
    private final LookUpTable lut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TwoDCoordSys generate(GridCoordSystem coordSys) {
        CurvilinearGrid curvGrid = new CurvilinearGrid(coordSys);
        double minLutResolution = Math.sqrt(curvGrid.getMeanCellArea()) / 3.0;
        logger.debug("minLutResolution = {}", (Object)minLutResolution);
        Map<CurvilinearGrid, TwoDCoordSys> map = CACHE;
        synchronized (map) {
            TwoDCoordSys lutCoordSys = CACHE.get(curvGrid);
            if (lutCoordSys == null) {
                logger.debug("Need to generate new look-up table");
                LookUpTable lut = new LookUpTable(curvGrid, minLutResolution);
                logger.debug("Generated new look-up table");
                lutCoordSys = new TwoDCoordSys(curvGrid, lut);
                CACHE.put(curvGrid, lutCoordSys);
            } else {
                logger.debug("Look-up table found in cache");
            }
            return lutCoordSys;
        }
    }

    private TwoDCoordSys(CurvilinearGrid curvGrid, LookUpTable lut) {
        this.curvGrid = curvGrid;
        this.lut = lut;
    }

    @Override
    public int[] lonLatToGrid(LonLatPosition lonLatPoint) {
        int[] lutCoords = this.lut.getGridCoordinates(lonLatPoint.getLongitude(), lonLatPoint.getLatitude());
        if (lutCoords == null) {
            return null;
        }
        CurvilinearGrid.Cell cell = this.curvGrid.getCell(lutCoords[0], lutCoords[1]);
        if (cell.contains(lonLatPoint)) {
            return lutCoords;
        }
        for (CurvilinearGrid.Cell neighbour : cell.getEdgeNeighbours()) {
            if (!neighbour.contains(lonLatPoint)) continue;
            return new int[]{neighbour.getI(), neighbour.getJ()};
        }
        for (CurvilinearGrid.Cell neighbour : cell.getCornerNeighbours()) {
            if (!neighbour.contains(lonLatPoint)) continue;
            return new int[]{neighbour.getI(), neighbour.getJ()};
        }
        return lutCoords;
    }

    @Override
    public LonLatPosition gridToLonLat(int i, int j) {
        if (i >= 0 && i < this.curvGrid.getNi() && j >= 0 && j < this.curvGrid.getNj()) {
            return this.curvGrid.getMidpoint(i, j);
        }
        return null;
    }
}

