/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.joda.time.DateTime;
import uk.ac.rdg.resc.ncwms.util.Range;

public final class Ranges {
    private Ranges() {
        throw new AssertionError();
    }

    public static <T extends Comparable<? super T>> Range<T> findMinMax(Collection<T> coll) {
        Comparable minCandidate;
        Iterator<T> i = coll.iterator();
        Comparable maxCandidate = minCandidate = (Comparable)i.next();
        while (i.hasNext()) {
            Comparable next = (Comparable)i.next();
            if (next == null) continue;
            if (minCandidate == null || next.compareTo(minCandidate) < 0) {
                minCandidate = next;
            }
            if (maxCandidate != null && next.compareTo(maxCandidate) <= 0) continue;
            maxCandidate = next;
        }
        return new SimpleRange<Comparable>(minCandidate, maxCandidate);
    }

    public static <T> Range<T> newRange(T min, T max) {
        return new SimpleRange<Comparable>((Comparable)min, (Comparable)max);
    }

    public static <T> Range<T> newRange(T min, T max, Comparator<? super T> comp) {
        return new SimpleRangeWithComparator<T>(min, max, comp);
    }

    public static Range<DateTime> newDateTimeRange(DateTime dt1, DateTime dt2) {
        return Ranges.newRange(dt1, dt2, null);
    }

    public static <T> Range<T> emptyRange() {
        return new SimpleRangeWithComparator<Object>(null, null, null);
    }

    private static final class SimpleRangeWithComparator<T>
    extends AbstractRange<T> {
        public SimpleRangeWithComparator(T min, T max, Comparator<? super T> comparator) {
            super(min, max, comparator);
        }

        @Override
        protected int compare(T val1, T val2) {
            return this.comp.compare(val1, val2);
        }
    }

    private static final class SimpleRange<T extends Comparable<? super T>>
    extends AbstractRange<T> {
        public SimpleRange(T min, T max) {
            super(min, max, null);
        }

        @Override
        protected int compare(T val1, T val2) {
            return val1.compareTo(val2);
        }
    }

    private static abstract class AbstractRange<T>
    implements Range<T> {
        private final T min;
        private final T max;
        protected final Comparator<? super T> comp;

        protected AbstractRange(T min, T max, Comparator<? super T> comp) {
            if (min == null && max != null || min != null && max == null) {
                throw new IllegalArgumentException("min and max must both be null or non-null");
            }
            this.min = min;
            this.max = max;
            this.comp = comp;
            if (!this.isEmpty() && this.compare(min, max) > 0) {
                throw new IllegalArgumentException("min must not be greater than max");
            }
        }

        protected abstract int compare(T var1, T var2);

        @Override
        public final boolean contains(T val) {
            if (this.isEmpty()) {
                return false;
            }
            return this.compare(this.min, val) <= 0 && this.compare(this.max, val) >= 0;
        }

        @Override
        public final boolean isEmpty() {
            return this.getMinimum() == null && this.getMaximum() == null;
        }

        @Override
        public final T getMinimum() {
            return this.min;
        }

        @Override
        public final T getMaximum() {
            return this.max;
        }

        @Override
        public final Comparator<? super T> comparator() {
            return this.comp;
        }

        public final String toString() {
            return String.format("%s,%s", this.min, this.max);
        }
    }
}

