/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.joda.time.DateTime;
import org.opengis.metadata.extent.GeographicBoundingBox;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.PointList;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;

public abstract class AbstractScalarLayer
implements ScalarLayer {
    protected String id;
    protected String title = null;
    protected String abstr = null;
    protected String units;
    protected String zUnits;
    protected List<Double> zValues = Collections.emptyList();
    protected boolean zPositive;
    protected GeographicBoundingBox bbox = DefaultGeographicBoundingBox.WORLD;
    protected HorizontalCoordSys horizCoordSys;

    public AbstractScalarLayer(String id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return WmsUtils.createUniqueLayerName(this.getDataset().getId(), this.getId());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getLayerAbstract() {
        return this.abstr;
    }

    public void setLayerAbstract(String abstr) {
        this.abstr = abstr;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public String getElevationUnits() {
        return this.zUnits;
    }

    public void setElevationUnits(String zUnits) {
        this.zUnits = zUnits;
    }

    @Override
    public List<Double> getElevationValues() {
        return this.zValues;
    }

    public void setElevationValues(List<Double> zValues) {
        this.zValues = zValues;
    }

    @Override
    public boolean isElevationPositive() {
        return this.zPositive;
    }

    public void setElevationPositive(boolean zPositive) {
        this.zPositive = zPositive;
    }

    @Override
    public GeographicBoundingBox getGeographicBoundingBox() {
        return this.bbox;
    }

    public void setGeographicBoundingBox(GeographicBoundingBox bbox) {
        this.bbox = bbox;
    }

    public void setGeographicBoundingBox(double[] bbox) {
        if (bbox == null) {
            throw new NullPointerException();
        }
        if (bbox.length != 4) {
            throw new IllegalArgumentException("Bounding box must have four elements");
        }
        this.bbox = new DefaultGeographicBoundingBox(bbox[0], bbox[2], bbox[1], bbox[3]);
    }

    @Override
    public HorizontalCoordSys getHorizontalCoordSys() {
        return this.horizCoordSys;
    }

    public void setHorizontalCoordSys(HorizontalCoordSys horizCoordSys) {
        this.horizCoordSys = horizCoordSys;
    }

    protected boolean hasTimeAxis() {
        return !this.getTimeValues().isEmpty();
    }

    protected boolean hasElevationAxis() {
        return !this.getElevationValues().isEmpty();
    }

    @Override
    public DateTime getCurrentTimeValue() {
        int currentTimeIndex = this.getCurrentTimeIndex();
        if (currentTimeIndex < 0) {
            return null;
        }
        return this.getTimeValues().get(currentTimeIndex);
    }

    @Override
    public DateTime getDefaultTimeValue() {
        return this.getCurrentTimeValue();
    }

    protected int getCurrentTimeIndex() {
        if (this.getTimeValues().size() == 0) {
            return -1;
        }
        int index = WmsUtils.findTimeIndex(this.getTimeValues(), new DateTime());
        if (index >= 0) {
            return index;
        }
        int insertionPoint = -(index + 1);
        if (insertionPoint > 0) {
            return insertionPoint - 1;
        }
        return 0;
    }

    public int findAndCheckTimeIndex(DateTime target) throws InvalidDimensionValueException {
        if (!this.hasTimeAxis()) {
            return -1;
        }
        int index = WmsUtils.findTimeIndex(this.getTimeValues(), target);
        if (index >= 0) {
            return index;
        }
        throw new InvalidDimensionValueException("time", WmsUtils.dateTimeToISO8601(target));
    }

    @Override
    public double getDefaultElevationValue() {
        Iterator<Double> it = this.getElevationValues().iterator();
        if (!it.hasNext()) {
            return Double.NaN;
        }
        Double candidate = it.next();
        while (it.hasNext()) {
            Double next = it.next();
            if (Double.compare(Math.abs(next), Math.abs(candidate)) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    protected int findElevationIndex(double targetVal) {
        List<Double> zVals = this.getElevationValues();
        for (int i = 0; i < zVals.size(); ++i) {
            if (zVals.get(i) != targetVal && !(Math.abs((zVals.get(i) - targetVal) / targetVal) < 1.0E-5)) continue;
            return i;
        }
        return -1;
    }

    public int findAndCheckElevationIndex(double targetVal) throws InvalidDimensionValueException {
        if (!this.hasElevationAxis()) {
            return -1;
        }
        int index = this.findElevationIndex(targetVal);
        if (index >= 0) {
            return index;
        }
        throw new InvalidDimensionValueException("elevation", "" + targetVal);
    }

    @Override
    public boolean isLogScaling() {
        return false;
    }

    @Override
    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get(null);
    }

    @Override
    public List<Float> readPointList(DateTime time, double elevation, PointList pointList) throws InvalidDimensionValueException, IOException {
        ArrayList<Float> vals = new ArrayList<Float>(pointList.size());
        for (HorizontalPosition xy : pointList.asList()) {
            vals.add(this.readSinglePoint(time, elevation, xy));
        }
        return vals;
    }

    @Override
    public List<Float> readTimeseries(List<DateTime> times, double elevation, HorizontalPosition xy) throws InvalidDimensionValueException, IOException {
        ArrayList<Float> vals = new ArrayList<Float>(times.size());
        for (DateTime time : times) {
            vals.add(this.readSinglePoint(time, elevation, xy));
        }
        return vals;
    }
}

