/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.wms;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.AbstractScalarLayer;

public abstract class AbstractTimeAggregatedLayer
extends AbstractScalarLayer {
    protected final List<TimestepInfo> timesteps = new ArrayList<TimestepInfo>();
    private final List<DateTime> dateTimes = new AbstractList<DateTime>(){

        @Override
        public DateTime get(int index) {
            return AbstractTimeAggregatedLayer.this.timesteps.get(index).getDateTime();
        }

        @Override
        public int size() {
            return AbstractTimeAggregatedLayer.this.timesteps.size();
        }
    };

    public AbstractTimeAggregatedLayer(String id) {
        super(id);
    }

    @Override
    public Chronology getChronology() {
        if (this.timesteps.isEmpty()) {
            return null;
        }
        return this.timesteps.get(0).timestep.getChronology();
    }

    @Override
    public List<DateTime> getTimeValues() {
        return this.dateTimes;
    }

    public void addTimestepInfo(DateTime dt, String filename, int indexInFile) {
        TimestepInfo tInfo = new TimestepInfo(dt, filename, indexInFile);
        int index = WmsUtils.findTimeIndex(this.getTimeValues(), dt);
        if (index >= 0) {
            TimestepInfo existingTStep = this.timesteps.get(index);
            if (tInfo.getIndexInFile() < existingTStep.getIndexInFile()) {
                existingTStep = tInfo;
            }
        } else {
            int insertionPoint = -(index + 1);
            this.timesteps.add(insertionPoint, tInfo);
        }
    }

    protected static class TimestepInfo {
        private DateTime timestep;
        private String filename;
        private int indexInFile;

        public TimestepInfo(DateTime timestep, String filename, int indexInFile) {
            if (timestep == null || filename == null) {
                throw new NullPointerException();
            }
            if (indexInFile < 0) {
                throw new IllegalArgumentException("indexInFile must be >= 0");
            }
            this.timestep = timestep;
            this.filename = filename;
            this.indexInFile = indexInFile;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getIndexInFile() {
            return this.indexInFile;
        }

        public DateTime getDateTime() {
            return this.timestep;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TimestepInfo)) {
                return false;
            }
            TimestepInfo otherTstep = (TimestepInfo)obj;
            return this.timestep.isEqual((ReadableInstant)otherTstep.timestep) && this.indexInFile == otherTstep.indexInFile && this.filename.equals(otherTstep.filename);
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + this.timestep.hashCode();
            hash = 41 * hash + this.filename.hashCode();
            hash = 41 * hash + this.indexInFile;
            return hash;
        }
    }
}

