/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.wms;

import java.io.IOException;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.opengis.metadata.extent.GeographicBoundingBox;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.util.Ranges;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Dataset;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public class SimpleVectorLayer
implements VectorLayer {
    private final String id;
    private final ScalarLayer east;
    private final ScalarLayer north;

    public SimpleVectorLayer(String id, ScalarLayer east, ScalarLayer north) {
        this.id = id;
        this.east = east;
        this.north = north;
    }

    @Override
    public ScalarLayer getEastwardComponent() {
        return this.east;
    }

    @Override
    public ScalarLayer getNorthwardComponent() {
        return this.north;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLayerAbstract() {
        return "Automatically-generated vector field, composed of the fields " + this.east.getTitle() + " and " + this.north.getTitle();
    }

    @Override
    public String getName() {
        return WmsUtils.createUniqueLayerName(this.getDataset().getId(), this.getId());
    }

    @Override
    public String getTitle() {
        return this.id;
    }

    @Override
    public Dataset getDataset() {
        return this.east.getDataset();
    }

    @Override
    public String getUnits() {
        return this.east.getUnits();
    }

    @Override
    public boolean isQueryable() {
        return this.east.isQueryable();
    }

    @Override
    public GeographicBoundingBox getGeographicBoundingBox() {
        return this.east.getGeographicBoundingBox();
    }

    @Override
    public HorizontalCoordSys getHorizontalCoordSys() {
        return this.east.getHorizontalCoordSys();
    }

    @Override
    public Chronology getChronology() {
        return this.east.getChronology();
    }

    @Override
    public List<DateTime> getTimeValues() {
        return this.east.getTimeValues();
    }

    @Override
    public DateTime getCurrentTimeValue() {
        return this.east.getCurrentTimeValue();
    }

    @Override
    public DateTime getDefaultTimeValue() {
        return this.east.getDefaultTimeValue();
    }

    @Override
    public List<Double> getElevationValues() {
        return this.east.getElevationValues();
    }

    @Override
    public double getDefaultElevationValue() {
        return this.east.getDefaultElevationValue();
    }

    @Override
    public String getElevationUnits() {
        return this.east.getElevationUnits();
    }

    @Override
    public boolean isElevationPositive() {
        return this.east.isElevationPositive();
    }

    @Override
    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get(null);
    }

    @Override
    public boolean isLogScaling() {
        return this.east.isLogScaling();
    }

    @Override
    public int getDefaultNumColorBands() {
        return this.east.getDefaultNumColorBands();
    }

    @Override
    public Range<Float> getApproxValueRange() {
        try {
            return WmsUtils.estimateValueRange(this);
        }
        catch (IOException ioe) {
            return Ranges.newRange(Float.valueOf(-50.0f), Float.valueOf(50.0f));
        }
    }
}

