/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.server.metadata.controller.IMetadataContoller;
import thredds.servlet.DataRootHandler;

public abstract class AbstractMetadataController
implements ServletContextAware,
IMetadataContoller {
    private static Logger _log = LoggerFactory.getLogger(AbstractMetadataController.class);
    protected static Logger _logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    protected boolean _allow = false;
    protected String _metadataServiceType = "";
    protected ServletContext sc;
    protected File xslFile;

    public void setServletContext(ServletContext sc) {
        this.sc = sc;
    }

    protected void isAllowed(boolean allow, String metadataServiceType, HttpServletResponse res) throws Exception {
        if (!allow) {
            res.sendError(403, String.valueOf(metadataServiceType) + " service not supported");
            return;
        }
    }

    protected void returnError(String message, String metadataServiceType, HttpServletResponse res) throws Exception {
        res.sendError(500, String.valueOf(metadataServiceType) + " service failed. " + message);
    }

    @Override
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
    }

    protected InvDataset getThreddsDataset(HttpServletRequest req) {
        String msg;
        String invDatasetString;
        String catalogString;
        InvDataset ids;
        InvCatalog catalog;
        block8: {
            catalog = null;
            ids = null;
            String catalogPath = null;
            catalogString = req.getParameter("catalog");
            invDatasetString = req.getParameter("dataset");
            DataRootHandler drh = DataRootHandler.getInstance();
            String dynamicCatStr = "thredds/catalog/";
            String staticCatStr = "thredds/";
            if (catalogString.contains(".html")) {
                catalogString = String.valueOf(catalogString.substring(0, catalogString.length() - 4)) + "xml";
            }
            catalogPath = catalogString.contains(dynamicCatStr) ? catalogString.substring(catalogString.indexOf(dynamicCatStr) + dynamicCatStr.length(), catalogString.length()) : catalogString.substring(catalogString.indexOf(staticCatStr) + staticCatStr.length(), catalogString.length());
            _log.debug("ncISO catalogPath=" + catalogPath + "; " + "dataset=" + invDatasetString + "; invDatasetString=" + invDatasetString);
            catalog = drh.getCatalog(catalogPath, new URI(catalogString));
            if (catalog != null) break block8;
            _log.error("catalog is not found using catalogPath: " + catalogPath + "; and catalogString: " + catalogString);
            return null;
        }
        _log.debug("catalog found! catalog name: " + catalog.getName());
        ids = catalog.findDatasetByID(invDatasetString);
        if (ids == null) {
            _log.debug("ids dataset not found!: " + invDatasetString);
            return null;
        }
        _log.debug("Dataset information retrieved!" + ids.getCatalogUrl() + "; id=" + ids.getName());
        try {
            if (ids.hasNestedDatasets()) {
                String nestedDataset = invDatasetString.substring(invDatasetString.lastIndexOf("/") + 1, invDatasetString.length());
                InvDatasetImpl nds = ids.findDatasetByName(nestedDataset);
                _log.debug("nestedDataset name: " + nestedDataset);
                return nds;
            }
            return ids;
        }
        catch (URISyntaxException e) {
            msg = "Bad URI syntax [" + catalogString + "]: " + e.getMessage();
            _log.error(String.valueOf(msg) + " getTDSMetadata failed: ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            msg = e.getMessage();
            _log.error(String.valueOf(msg) + " getTDSMetadata failed: ", (Throwable)e);
            return null;
        }
    }
}

