/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.catalog.InvDataset;
import thredds.server.metadata.controller.AbstractMetadataController;
import thredds.server.metadata.exception.ThreddsUtilitiesException;
import thredds.server.metadata.service.EnhancedMetadataService;
import thredds.server.metadata.util.DatasetHandlerAdapter;
import thredds.server.metadata.util.ThreddsTranslatorUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.dataset.NetcdfDataset;

@Controller
@RequestMapping(value={"/iso"})
public class IsoController
extends AbstractMetadataController {
    private static Logger _log = LoggerFactory.getLogger(IsoController.class);

    protected String getPath() {
        return String.valueOf(this._metadataServiceType) + "/";
    }

    public void init() throws ServletException {
        this._metadataServiceType = "ISO";
        _logServerStartup.info("Metadata ISO - initialization start");
        this._allow = ThreddsConfig.getBoolean((String)"NCISO.isoAllow", (boolean)false);
        _logServerStartup.info("NCISO.isoAllow = " + this._allow);
        String ncIsoXslFilePath = String.valueOf(this.sc.getRealPath("/WEB-INF/classes/resources/xsl/nciso")) + "/UnidataDD2MI.xsl";
        this.xslFile = new File(ncIsoXslFilePath);
    }

    public void destroy() {
        NetcdfDataset.shutdown();
        _logServerStartup.info("Metadata ISO - destroy done");
    }

    @Override
    @RequestMapping(params={})
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block12: {
            _log.info("Handling ISO metadata request.");
            NetcdfDataset netCdfDataset = null;
            try {
                this.isAllowed(this._allow, this._metadataServiceType, res);
                res.setContentType("text/xml");
                netCdfDataset = DatasetHandlerAdapter.openDataset(req, res);
                if (netCdfDataset == null) {
                    res.sendError(404, "ThreddsIso Extension: Requested resource not found.");
                } else {
                    StringWriter writer = new StringWriter();
                    InvDataset ids = this.getThreddsDataset(req);
                    EnhancedMetadataService.enhance(netCdfDataset, ids, writer);
                    String ncml = ((Object)writer).toString();
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    ByteArrayInputStream is = new ByteArrayInputStream(ncml.getBytes("UTF-8"));
                    ThreddsTranslatorUtil.transform(this.xslFile, (InputStream)is, (Writer)res.getWriter());
                    res.getWriter().flush();
                }
            }
            catch (ThreddsUtilitiesException tue) {
                String errMsg = "Error in " + this._metadataServiceType + ": " + req.getQueryString();
                _log.error(errMsg, (Throwable)tue);
                try {
                    this.returnError(errMsg, this._metadataServiceType, res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
                break block12;
            }
            catch (Exception e) {
                try {
                    String errMsg = "Error in " + this._metadataServiceType + ": " + req.getQueryString();
                    _log.error(errMsg, (Throwable)e);
                    try {
                        this.returnError(errMsg, this._metadataServiceType, res);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    DatasetHandlerAdapter.closeDataset(netCdfDataset);
                    throw throwable;
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
                break block12;
            }
            DatasetHandlerAdapter.closeDataset(netCdfDataset);
        }
    }
}

