/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.log4j.Logger;
import thredds.server.metadata.bean.Extent;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class ThreddsExtentUtil {
    private static Logger _log = Logger.getLogger(ThreddsExtentUtil.class);

    private static Extent doGetExtent(String url) throws Exception {
        Extent ext = null;
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset((String)url);
            ext = ThreddsExtentUtil.doGetExtent(ncd);
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "Could not load NETCDF file: " + url + " because of Exception. " + e.getLocalizedMessage();
            _log.error((Object)err, (Throwable)e);
        }
        return ext;
    }

    private static Extent doGetExtent(NetcdfDataset ncd) throws Exception {
        Extent ext = new Extent();
        List coordAxes = ncd.getCoordinateAxes();
        try {
            for (CoordinateAxis coordAxis : coordAxes) {
                if (coordAxis.getAxisType() == AxisType.Lat) {
                    ext._minLat = coordAxis.getMinValue();
                    ext._maxLat = coordAxis.getMaxValue();
                    ext._latUnits = coordAxis.getUnitsString();
                    ext._latRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        ext._latRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)(coordAxis.getSize() - 1L);
                    }
                }
                if (coordAxis.getAxisType() == AxisType.Lon) {
                    ext._minLon = coordAxis.getMinValue();
                    ext._maxLon = coordAxis.getMaxValue();
                    ext._lonUnits = coordAxis.getUnitsString();
                    ext._lonRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        ext._lonRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)(coordAxis.getSize() - 1L);
                    }
                }
                if (coordAxis.getAxisType() == AxisType.Time && coordAxis.getFullName().equalsIgnoreCase("TIME")) {
                    _log.info((Object)("numTimeElems=" + coordAxis.getSize()));
                    _log.info((Object)("axisName=" + coordAxis.getFullName()));
                    ThreddsExtentUtil.logAvailableMemory("Retrieving Time coordAxis values");
                    ext._minTime = Double.toString(coordAxis.getMinValue());
                    ext._maxTime = Double.toString(coordAxis.getMaxValue());
                    String rawMinTime = Double.toString(coordAxis.getMinValue());
                    String rawMaxTime = Double.toString(coordAxis.getMaxValue());
                    _log.info((Object)("udunits string = " + rawMinTime + " " + coordAxis.getUnitsString()));
                    Date startDate = DateUnit.getStandardDate((String)(rawMinTime + " " + coordAxis.getUnitsString()));
                    Date endDate = DateUnit.getStandardDate((String)(rawMaxTime + " " + coordAxis.getUnitsString()));
                    DateFormatter df = new DateFormatter();
                    ext._minTime = df.toDateTimeStringISO(startDate);
                    ext._maxTime = df.toDateTimeStringISO(endDate);
                    long duration = endDate.getTime() - startDate.getTime();
                    ext._timeDuration = DurationFormatUtils.formatDurationISO((long)duration);
                    double timeRes = 0.0;
                    if (coordAxis.getSize() - 1L > 0L) {
                        timeRes = duration / 1000L / (coordAxis.getSize() - 1L);
                    }
                    ext._timeRes = Double.toString(timeRes);
                    ext._timeUnits = "seconds";
                }
                if (coordAxis.getAxisType() != AxisType.Height || !coordAxis.getFullName().equalsIgnoreCase("DEPTH")) continue;
                _log.info((Object)("axisName=" + coordAxis.getFullName()));
                ext._minHeight = coordAxis.getMinValue();
                ext._maxHeight = coordAxis.getMaxValue();
                ext._heightUnits = coordAxis.getUnitsString();
                ext._vOrientation = coordAxis.getPositive();
                ext._heightRes = 0.0;
                if (coordAxis.getSize() - 1L <= 0L) continue;
                ext._heightRes = (coordAxis.getMaxValue() - coordAxis.getMinValue()) / (double)coordAxis.getSize() - 1.0;
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error in doGetExtent", (Throwable)e);
        }
        return ext;
    }

    public static Extent getExtent(String url) throws Exception {
        return ThreddsExtentUtil.doGetExtent(url);
    }

    public static Extent getExtent(NetcdfDataset ncd) throws Exception {
        return ThreddsExtentUtil.doGetExtent(ncd);
    }

    private static void logAvailableMemory(String message) {
        int mb = 0x100000;
        _log.debug((Object)message);
        _log.info((Object)("Total Memory: " + Runtime.getRuntime().totalMemory() / (long)mb));
        _log.info((Object)("Free Memory: " + Runtime.getRuntime().freeMemory() / (long)mb));
    }
}

