/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class RollbackException
extends RestartRequiredException {
    private final VLSN lastTxnEnd;
    private final VLSN matchpointVLSN;
    private final long matchpointLsn;
    private final String nodeName;

    public RollbackException(RepImpl repImpl, VLSN lastTxnEnd, VLSN matchpointVLSN, long matchpointLsn) {
        super(repImpl, EnvironmentFailureReason.HARD_RECOVERY);
        this.lastTxnEnd = lastTxnEnd;
        this.matchpointVLSN = matchpointVLSN;
        this.matchpointLsn = matchpointLsn;
        this.nodeName = repImpl.getName();
    }

    public String getMessage() {
        return "Node " + this.nodeName + " must be rolled back, recovery is " + "required. All existing ReplicatedEnvironment handles must be " + " closed and reinstantiated. Log files were truncated at file 0x" + DbLsn.getFileNumber(this.matchpointLsn) + ", offset 0x" + DbLsn.getFileOffset(this.matchpointLsn) + ". LastTxnEnd=" + this.lastTxnEnd + " matchpoint at " + this.matchpointVLSN;
    }

    public RollbackException(String message, RollbackException cause) {
        super(message, cause);
        this.lastTxnEnd = cause.lastTxnEnd;
        this.matchpointVLSN = cause.matchpointVLSN;
        this.matchpointLsn = cause.matchpointLsn;
        this.nodeName = cause.nodeName;
    }

    public RollbackException wrapSelf(String msg) {
        return new RollbackException(msg, this);
    }
}

