/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Acceptor
extends StoppableThread {
    private final RepNode repNode;
    private final Protocol protocol;
    private Proposer.Proposal promisedProposal = null;
    private Protocol.Value acceptedValue = null;
    private final SuggestionGenerator suggestionGenerator;
    private final Logger logger;
    private final Formatter formatter;
    public static final String SERVICE_NAME = "Acceptor";

    public Acceptor(Protocol protocol, RepNode repNode, SuggestionGenerator suggestionGenerator) {
        super(repNode.getRepImpl());
        this.setName("Acceptor Thread #" + repNode.getNameIdPair());
        this.repNode = repNode;
        this.suggestionGenerator = suggestionGenerator;
        this.protocol = protocol;
        this.logger = this.envImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(repNode.getNameIdPair());
    }

    public synchronized void shutdown() throws InterruptedException {
        if (this.shutdownDone()) {
            return;
        }
        if (Thread.currentThread() != this) {
            this.interrupt();
            this.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServiceDispatcher serviceDispatcher = this.repNode.getServiceDispatcher();
        serviceDispatcher.register(SERVICE_NAME, new LinkedBlockingQueue<SocketChannel>());
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor started");
        SocketChannel channel = null;
        try {
            try {
                Object var10_12;
                PrintWriter out;
                BufferedReader in;
                Socket socket;
                while (true) {
                    block20: {
                        block19: {
                            block18: {
                                if ((channel = serviceDispatcher.takeChannel(SERVICE_NAME, true, this.protocol.getReadTimeout())) == null) continue;
                                socket = channel.socket();
                                in = null;
                                out = null;
                                try {
                                    try {
                                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                        out = new PrintWriter(socket.getOutputStream(), true);
                                        String requestLine = in.readLine();
                                        if (requestLine == null) {
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor: EOF on request");
                                            var10_12 = null;
                                            break block18;
                                        }
                                        TextProtocol.RequestMessage requestMessage = null;
                                        try {
                                            requestMessage = this.protocol.parseRequest(requestLine);
                                        }
                                        catch (TextProtocol.InvalidMessageException e) {
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Message format error: " + e.getMessage());
                                            Protocol protocol = this.protocol;
                                            protocol.getClass();
                                            out.println(new TextProtocol.ProtocolError(protocol, e).wireFormat());
                                            var10_12 = null;
                                            Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                            this.cleanup();
                                            continue;
                                        }
                                        TextProtocol.ResponseMessage responseMessage = null;
                                        if (requestMessage.getOp() == this.protocol.PROPOSE) {
                                            responseMessage = this.process((Protocol.Propose)requestMessage);
                                        } else if (requestMessage.getOp() == this.protocol.ACCEPT) {
                                            responseMessage = this.process((Protocol.Accept)requestMessage);
                                        } else {
                                            if (requestMessage.getOp() == this.protocol.SHUTDOWN) {
                                                break;
                                            }
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Unrecognized request: " + requestLine);
                                            break block19;
                                        }
                                        out.println(responseMessage.wireFormat());
                                        break block20;
                                    }
                                    catch (IOException e) {
                                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "IO error on socket: " + e.getMessage());
                                        var10_12 = null;
                                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                        this.cleanup();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var10_12 = null;
                                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                    this.cleanup();
                                    throw throwable;
                                }
                            }
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                            this.cleanup();
                            continue;
                        }
                        var10_12 = null;
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                        this.cleanup();
                        continue;
                    }
                    var10_12 = null;
                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                    this.cleanup();
                }
                var10_12 = null;
                Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                this.cleanup();
                Object var12_14 = null;
                serviceDispatcher.cancel(SERVICE_NAME);
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    Object var12_15 = null;
                    serviceDispatcher.cancel(SERVICE_NAME);
                    this.cleanup();
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Acceptor unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            this.cleanup();
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            serviceDispatcher.cancel(SERVICE_NAME);
            this.cleanup();
            throw throwable;
        }
    }

    TextProtocol.ResponseMessage process(Protocol.Propose propose) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(propose.getProposal()) > 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Propose: " + propose.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.promisedProposal = propose.getProposal();
        Protocol.Value suggestedValue = this.suggestionGenerator.get(this.promisedProposal);
        long suggestionRanking = this.suggestionGenerator.getRanking(this.promisedProposal);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Suggested Value: " + suggestedValue + " Suggestion Ranking: " + suggestionRanking);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Promise(protocol, this.promisedProposal, this.acceptedValue, suggestedValue, suggestionRanking, this.repNode.getElectionPriority());
    }

    TextProtocol.ResponseMessage process(Protocol.Accept accept) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(accept.getProposal()) != 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Accept: " + accept.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.acceptedValue = accept.getValue();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Accepted: " + accept.getProposal() + " Value: " + this.acceptedValue);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Accepted(protocol, accept.getProposal(), this.acceptedValue);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public static interface SuggestionGenerator {
        public Protocol.Value get(Proposer.Proposal var1);

        public long getRanking(Proposer.Proposal var1);
    }
}

